/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONObject;

public class MailSimpleStructureTest
extends AbstractMailTest {
    private static final byte[] SIMPLE = "Date: Sat, 14 Nov 2009 17:03:09 +0100 (CET)\nFrom: Alice Doe <alice@foobar.com>\nTo: bob@foobar.com\nMessage-ID: <1837640730.5.1258214590077.JavaMail.foobar@foobar>\nSubject: The mail subject\nMIME-Version: 1.0\nContent-Type: text/plain; charset=US-ASCII\nContent-Disposition: inline; filename=foo.txt\nX-Priority: 3\n\nMail text.\n\nPeople have been asking for support for the IMAP IDLE command for quite\na few years and I think I've finally figured out how to provide such\nsupport safely. The difficulty isn't in executing the command, which\nis quite straightforward, the difficulty is in deciding how to expose\nit to applications, and inhandling the multithreading issues that\narise.".getBytes();
    private static final byte[] SIMPLE2 = "Date: Sat, 14 Nov 2009 17:03:09 +0100 (CET)\nFrom: Alice Doe <alice@foobar.com>\nTo: bob@foobar.com\nMessage-ID: <1837640730.5.1258214590077.JavaMail.foobar@foobar>\nSubject: The mail subject\nMIME-Version: 1.0\nContent-Type: text/plain; charset=\"utf-8\"\nContent-Transfer-Encoding: base64\nContent-Disposition: inline; filename=foo.txt\nX-Priority: 3\n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\ndGhlIG9yaWdpbmFsIG1lc3NhZ2UgZnJvbSB0aGUgSW5ib3guDQo=\n\n--_000_412AE9CFB27D0D40B5A7FEEA6EEE2F440DB295F1E1vsr00a00802kr_\nContent-Type: text/html; charset=\"utf-8\"\nContent-Transfer-Encoding: base64\n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\nDQo8L2ZvbnQ+DQo8L2JvZHk+DQo8L2h0bWw+DQo=".getBytes();

    public MailSimpleStructureTest() {
    }

    public MailSimpleStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailSimpleStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailSimpleStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailSimpleStructureTest.assertTrue((String)"Body object is not a JSON object.", (boolean)(bodyObject instanceof JSONObject));
            JSONObject jsonBodyObject = (JSONObject)bodyObject;
            String id = jsonBodyObject.getString("id");
            MailSimpleStructureTest.assertEquals((String)"Wring part ID.", (String)"1", (String)id);
            JSONObject jsonHeaderObject = jsonMailObject.getJSONObject("headers");
            JSONObject jsonContentTypeObject = jsonHeaderObject.getJSONObject("content-type");
            JSONObject paramsObject = jsonContentTypeObject.getJSONObject("params");
            MailSimpleStructureTest.assertTrue((String)"Charset parameter should be UTF-8, but isn't.", (boolean)"UTF-8".equalsIgnoreCase(paramsObject.getString("charset")));
        }
        catch (Exception e) {
            e.printStackTrace();
            MailSimpleStructureTest.fail((String)e.getMessage());
        }
    }

    public void testMIMEStructure2() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE2);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailSimpleStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailSimpleStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailSimpleStructureTest.assertTrue((String)"Body object is not a JSON object.", (boolean)(bodyObject instanceof JSONObject));
            JSONObject jsonBodyObject = (JSONObject)bodyObject;
            String id = jsonBodyObject.getString("id");
            MailSimpleStructureTest.assertEquals((String)"Wring part ID.", (String)"1", (String)id);
            JSONObject jsonHeaderObject = jsonMailObject.getJSONObject("headers");
            MailSimpleStructureTest.assertFalse((String)"Content-Transfer-Encoding header should not be present.", (boolean)jsonHeaderObject.hasAndNotNull("content-transfer-encoding"));
        }
        catch (Exception e) {
            e.printStackTrace();
            MailSimpleStructureTest.fail((String)e.getMessage());
        }
    }
}

