/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.UpdateTest;
import com.openexchange.groupware.update.tasks.CreateGenconfTablesTask;
import java.sql.SQLException;

public class CreateGenconfTablesTaskTest
extends UpdateTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.execSafe("DROP TABLE genconf_attributes_strings", new Object[0]);
        this.execSafe("DROP TABLE genconf_attributes_bools", new Object[0]);
        this.execSafe("DROP TABLE sequence_genconf", new Object[0]);
        super.tearDown();
    }

    public void testShouldCreateStringAttributeTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT cid, id, value, name FROM genconf_attributes_strings", new Object[0]);
        }
        catch (SQLException x) {
            CreateGenconfTablesTaskTest.fail((String)("Expected table genconf_attributes_strings, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldCreateBooleanAttributeTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT cid, id, value, name FROM genconf_attributes_bools", new Object[0]);
        }
        catch (SQLException x) {
            CreateGenconfTablesTaskTest.fail((String)("Expected table genconf_attributes_bools, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldBeRunnableTwice() throws OXException {
        this.executeTask();
        this.executeTask();
    }

    public void testShouldCreateSequenceTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT cid, id FROM sequence_genconf", new Object[0]);
        }
        catch (SQLException x) {
            CreateGenconfTablesTaskTest.fail((String)("Expected table sequence_genconf, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldCreateEntryInSequenceTableForEveryContext() throws OXException, SQLException {
        this.executeTask();
        this.assertResult("SELECT 1 FROM sequence_genconf WHERE cid = " + this.existing_ctx_id, new Object[0]);
    }

    private void executeTask() throws OXException {
        new CreateGenconfTablesTask().perform(this.schema, this.existing_ctx_id);
    }
}

