/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.AbstractInfostoreActionTest;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.CreateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.CreateVersionAction;
import com.openexchange.tx.UndoableAction;
import java.sql.SQLException;

public class CreateVersionActionTest
extends AbstractInfostoreActionTest {
    CreateDocumentAction create = new CreateDocumentAction();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.create.setProvider(this.getProvider());
        this.create.setContext(this.getContext());
        this.create.setDocuments(this.getDocuments());
        this.create.setQueryCatalog(this.getQueryCatalog());
        this.create.perform();
    }

    @Override
    public void tearDown() throws Exception {
        this.create.undo();
        super.tearDown();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        CreateVersionAction createAction = new CreateVersionAction();
        createAction.setProvider(this.getProvider());
        createAction.setContext(this.getContext());
        createAction.setDocuments(this.getDocuments());
        createAction.setQueryCatalog(this.getQueryCatalog());
        return createAction;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        for (DocumentMetadata doc : this.getDocuments()) {
            this.checkInVersionTable(doc);
        }
    }

    @Override
    protected void verifyUndone() throws Exception {
        for (DocumentMetadata doc : this.getDocuments()) {
            this.checkNotInVersionTable(doc);
        }
    }

    private void checkInVersionTable(DocumentMetadata doc) throws OXException, SQLException {
        this.assertResult("SELECT 1 FROM infostore_document WHERE infostore_id = ? and cid = ?", doc.getId(), this.getContext().getContextId());
    }

    private void checkNotInVersionTable(DocumentMetadata doc) throws OXException, SQLException {
        this.assertNoResult("SELECT 1 FROM infostore_document WHERE infostore_id = ? and cid = ?", doc.getId(), this.getContext().getContextId());
    }
}

