/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.contact.helpers.DefaultContactComparator;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.Order;
import java.util.Locale;
import junit.framework.TestCase;

public class DefaultContactComparatorTest
extends TestCase {
    private Contact c1;
    private Contact c2;

    public void setUp() {
        this.c1 = new Contact();
        this.c2 = new Contact();
        this.c1.setObjectID(10);
        this.c2.setObjectID(11);
    }

    public void testIntegerField() {
        this.assertBigger(this.c2, this.c1, 1);
    }

    public void testStringField() {
        this.c1.setGivenName("Alpha");
        this.c2.setGivenName("Beta");
        this.assertBigger(this.c2, this.c1, 501);
    }

    public void testDateField() {
        this.c1.setBirthday(TimeTools.D("03.03.1981 00:00"));
        this.c2.setBirthday(TimeTools.D("04.01.1981 00:00"));
        this.assertBigger(this.c1, this.c2, 511);
    }

    public void testDesc() {
        this.assertBigger(this.c1, this.c2, 1, Order.DESCENDING);
    }

    public void testSpecial() {
        this.c1.setGivenName("Anne123");
        this.c2.setSurName("Anne2000");
        this.assertBigger(this.c2, this.c1, 607);
    }

    public void testUseCountGlobalFirst() {
        this.c1.setUseCount(0);
        this.c1.setParentFolderID(6);
        this.c2.setUseCount(23);
        this.c2.setParentFolderID(23);
        this.assertBigger(this.c1, this.c2, 609);
    }

    private void assertBigger(Contact c1, Contact c2, int field) {
        this.assertBigger(c1, c2, field, Order.ASCENDING);
    }

    private void assertBigger(Contact c1, Contact c2, int field, Order order) {
        DefaultContactComparatorTest.assertTrue((String)"c1 was lower or equal than c2", (0 < new DefaultContactComparator(field, order, Locale.US).compare(c1, c2) ? 1 : 0) != 0);
    }
}

