/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.ajax.request.AppointmentRequest;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AbstractCalendarTest;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.AppointmentSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class SlowCalendarTests
extends AbstractCalendarTest {
    public void testShouldSurviveLoadingInvalidPattern() throws Exception {
        CalendarDataObject cdao = this.appointments.buildRecurringAppointment();
        this.appointments.save(cdao);
        this.clean.add(cdao);
        this.invalidatePattern(cdao);
        try {
            CalendarDataObject reloaded = this.appointments.reload(cdao);
            SlowCalendarTests.assertTrue((reloaded.getRecurrenceType() == 0 ? 1 : 0) != 0);
            SlowCalendarTests.assertTrue((reloaded.getEndDate().getTime() < System.currentTimeMillis() + 864000000L ? 1 : 0) != 0);
            AppointmentSQLInterface sqlInterface = this.appointments.getCurrentAppointmentSQLInterface();
            Date SUPER_START = new Date(-2L);
            Date SUPER_END = new Date(Long.MAX_VALUE);
            int[] COLS = new int[]{1, 201, 202, 20, 221};
            int USER_ID = this.userId;
            int FOLDER_ID = cdao.getParentFolderID();
            SearchIterator iter = sqlInterface.getActiveAppointments(USER_ID, SUPER_START, SUPER_END, COLS);
            this.assertContains(iter, cdao);
            iter = sqlInterface.getAppointmentsBetween(USER_ID, SUPER_START, SUPER_END, COLS, 1, null);
            this.assertContains(iter, cdao);
            iter = sqlInterface.getAppointmentsBetweenInFolder(FOLDER_ID, COLS, SUPER_START, SUPER_END, 1, null);
            this.assertContains(iter, cdao);
            AppointmentSearchObject search = new AppointmentSearchObject();
            search.setFolder(cdao.getParentFolderID());
            search.setPattern("*");
            iter = sqlInterface.getAppointmentsByExtendedSearch(search, 1, null, COLS);
            this.assertContains(iter, cdao);
            iter = sqlInterface.getFreeBusyInformation(USER_ID, 1, SUPER_START, SUPER_END);
            this.assertContains(iter, cdao);
            iter = sqlInterface.getModifiedAppointmentsBetween(USER_ID, SUPER_START, SUPER_END, COLS, SUPER_START, 1, Order.NO_ORDER);
            this.assertContains(iter, cdao);
            iter = sqlInterface.getObjectsById((int[][])new int[][]{{cdao.getObjectID(), cdao.getParentFolderID()}}, COLS);
            this.assertContains(iter, cdao);
            AppointmentSearchObject searchObj = new AppointmentSearchObject();
            searchObj.setPattern("*");
            searchObj.addFolder(cdao.getParentFolderID());
            iter = sqlInterface.searchAppointments(searchObj, 1, null, COLS);
            this.assertContains(iter, cdao);
            sqlInterface.hasAppointmentsBetween(SUPER_START, new Date(SUPER_START.getTime() + 2592000000L));
            StringBuilder cols = new StringBuilder();
            for (int col : COLS) {
                cols.append(col).append(',');
            }
            cols.setLength(cols.length() - 1);
            String COLS_STRING = cols.toString();
            AppointmentRequest req = new AppointmentRequest(ServerSessionAdapter.valueOf((Session)this.session));
            JSONObject requestData = this.json("columns", COLS_STRING, "folder", String.valueOf(cdao.getParentFolderID()), "start", String.valueOf(SUPER_START.getTime()), "end", String.valueOf(SUPER_END.getTime()));
            JSONArray arr = req.actionAll(requestData);
            this.assertContains(arr, cdao);
            requestData.put("recurrence_master", true);
            arr = req.actionAll(requestData);
            this.assertContains(arr, cdao);
            arr = req.actionFreeBusy(this.json("id", Integer.toString(this.userId), "type", Integer.toString(1), "start", String.valueOf(SUPER_START.getTime()), "end", String.valueOf(SUPER_END.getTime())));
            this.assertContainsAsJSONObject(arr, cdao);
            JSONObject loaded = req.actionGet(this.json("id", Integer.toString(cdao.getObjectID()), "folder", Integer.toString(cdao.getParentFolderID())));
            SlowCalendarTests.assertEquals((int)loaded.getInt("id"), (int)cdao.getObjectID());
            req.actionHas(this.json("start", String.valueOf(SUPER_START.getTime()), "end", String.valueOf(SUPER_START.getTime() + 2592000000L)));
            JSONArray idArray = new JSONArray();
            idArray.put((Object)this.json("id", cdao.getObjectID(), "folder", cdao.getParentFolderID()));
            JSONObject jsonRequest = this.json("columns", COLS_STRING, "data", idArray);
            arr = req.actionList(jsonRequest);
            this.assertContains(arr, cdao);
            jsonRequest.put("recurrence_master", true);
            arr = req.actionList(jsonRequest);
            this.assertContains(arr, cdao);
            arr = req.actionNewAppointmentsSearch(this.json("columns", COLS_STRING, "start", String.valueOf(SUPER_START.getTime()), "end", String.valueOf(SUPER_END.getTime()), "limit", Integer.MAX_VALUE));
            this.assertContains(arr, cdao);
            requestData = this.json("columns", COLS_STRING, "data", this.json("pattern", "*", "folder", cdao.getParentFolderID()), "sort", 201, "order", "ASC");
            arr = req.actionSearch(requestData);
            this.assertContains(arr, cdao);
            requestData.put("start", SUPER_START.getTime());
            requestData.put("end", SUPER_END.getTime());
            arr = req.actionSearch(requestData);
            this.assertContains(arr, cdao);
            requestData.remove("start");
            requestData.remove("end");
            requestData.put("recurrence_master", true);
            arr = req.actionSearch(requestData);
            this.assertContains(arr, cdao);
            requestData.put("start", SUPER_START.getTime());
            requestData.put("end", SUPER_END.getTime());
            arr = req.actionSearch(requestData);
            this.assertContains(arr, cdao);
            requestData = this.json("columns", COLS_STRING, "start", String.valueOf(SUPER_START.getTime()), "end", String.valueOf(SUPER_END.getTime()), "timestamp", 0, "folder", cdao.getParentFolderID());
            arr = req.actionUpdates(requestData);
            this.assertContains(arr, cdao);
            requestData.put("recurrence_master", true);
            arr = req.actionUpdates(requestData);
            this.assertContains(arr, cdao);
        }
        catch (Exception x) {
            x.printStackTrace();
            SlowCalendarTests.fail((String)x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidatePattern(CalendarDataObject cdao) throws OXException {
        Connection con = null;
        Statement pstmt = null;
        String invalidPattern = "t|6|i|1|a|32|b|21|c|3|s|" + (System.currentTimeMillis() + 864000000L) + "|";
        try {
            con = Database.get((Context)this.ctx, (boolean)true);
            pstmt = con.prepareStatement("UPDATE prg_dates SET field06 = ? WHERE intfield01 = ?");
            pstmt.setString(1, invalidPattern);
            pstmt.setInt(2, cdao.getObjectID());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            SlowCalendarTests.fail((String)e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                Database.back((Context)this.ctx, (boolean)true, (Connection)con);
            }
        }
    }
}

