/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.ical;

import com.openexchange.dav.caldav.ical.SimpleICal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class ICalUtils {
    public static String formatAsUTC(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm'00Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static String fold(String content) {
        return content.replaceAll(".{75}", "$0\r\n ");
    }

    public static String unfold(String content) {
        return content.replaceAll("(?:\\r\\n?|\\n)[ \t]", "");
    }

    public static Date parseDate(SimpleICal.Property property) throws ParseException {
        if (null == property || null == property.getValue()) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        if ("DATE".equals(property.getAttribute("VALUE"))) {
            dateFormat.applyPattern("yyyyMMdd");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            String tzid = property.getAttribute("TZID");
            if (null != tzid) {
                dateFormat.setTimeZone(TimeZone.getTimeZone(tzid));
                dateFormat.applyPattern("yyyyMMdd'T'HHmmss");
            } else {
                dateFormat.applyPattern("yyyyMMdd'T'HHmmss'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
        }
        return dateFormat.parse(property.getValue());
    }

    public static String format(Date date, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm'00'");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    public static String format(Date date, String timeZoneID) {
        return ICalUtils.format(date, TimeZone.getTimeZone(timeZoneID));
    }

    public static List<Date[]> parsePeriods(SimpleICal.Property property) throws ParseException {
        String[] splitted;
        ArrayList<Date[]> periods = new ArrayList<Date[]>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (String value : splitted = property.getValue().split(",")) {
            if (0 >= value.trim().length()) continue;
            String from = value.substring(0, value.indexOf(47));
            String until = value.substring(value.indexOf(47) + 1);
            if (until.startsWith("PT")) {
                throw new UnsupportedOperationException("durations not implemented");
            }
            Date[] period = new Date[]{dateFormat.parse(from), dateFormat.parse(until)};
            periods.add(period);
        }
        return periods;
    }

    private ICalUtils() {
    }
}

