/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Tools {
    private static SimpleDateFormat utc = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    private Tools() {
    }

    public static String formatForICal(Date date) {
        return utc.format(date);
    }

    public static String formatForICal(Date date, boolean useDateValue) {
        return useDateValue ? dateFormat.format(date) : utc.format(date);
    }

    public static String formatForICalWithoutTimezone(Date date) {
        return new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(date);
    }

    static {
        utc.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

