/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.configuration.TestConfig;
import com.openexchange.exception.OXException;
import com.openexchange.tools.conf.AbstractConfig;

public class WebDAVConfig
extends AbstractConfig {
    private static final TestConfig.Property KEY = TestConfig.Property.WEBDAV_PROPS;
    private static WebDAVConfig singleton;

    protected String getPropertyFileName() throws OXException {
        String fileName = TestConfig.getProperty(KEY);
        if (null == fileName) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{KEY.getPropertyName()});
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() throws OXException {
        TestConfig.init();
        if (null != singleton) return;
        Class<WebDAVConfig> clazz = WebDAVConfig.class;
        synchronized (WebDAVConfig.class) {
            if (null != singleton) return;
            singleton = new WebDAVConfig();
            singleton.loadPropertiesInternal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String getProperty(Property key) {
        return singleton.getPropertyInternal(key.getPropertyName());
    }

    public static enum Property {
        HOSTNAME("hostname"),
        LOGIN("login"),
        PASSWORD("password"),
        PROTOCOL("protocol"),
        SECONDUSER("secondlogin");

        private final String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

