/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.subscribe.actions.AbstractSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.json.SubscriptionJSONWriter;
import org.json.JSONException;

public class NewSubscriptionRequest
extends AbstractSubscriptionRequest<NewSubscriptionResponse> {
    private Subscription subscription;
    private DynamicFormDescription formDescription;

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setFormDescription(DynamicFormDescription formDescription) {
        this.formDescription = formDescription;
    }

    public DynamicFormDescription getFormDescription() {
        return this.formDescription;
    }

    public NewSubscriptionRequest() {
    }

    public NewSubscriptionRequest(Subscription subscription, DynamicFormDescription formDescription) {
        this();
        this.setSubscription(subscription);
        this.setFormDescription(formDescription);
    }

    @Override
    public Object getBody() throws JSONException {
        try {
            return new SubscriptionJSONWriter().write(this.getSubscription(), this.getFormDescription(), null);
        }
        catch (OXException e) {
            throw new JSONException((Throwable)e);
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "new")};
    }

    @Override
    public AbstractAJAXParser<NewSubscriptionResponse> getParser() {
        return new AbstractAJAXParser<NewSubscriptionResponse>(this.getFailOnError()){

            @Override
            protected NewSubscriptionResponse createResponse(Response response) throws JSONException {
                return new NewSubscriptionResponse(response);
            }
        };
    }
}

