/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.actions.TokenLoginRequest;
import com.openexchange.ajax.session.actions.TokenLoginResponse;
import com.openexchange.ajax.session.actions.TokensRequest;
import com.openexchange.ajax.session.actions.TokensResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.java.Autoboxing;
import com.openexchange.sessiond.SessionExceptionCodes;

public class TokenLoginTest
extends AbstractAJAXSession {
    private String login;
    private String password;

    public TokenLoginTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
    }

    @Override
    protected void tearDown() throws Exception {
        this.login = null;
        this.password = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTokenLogin() throws Exception {
        AJAXSession session = new AJAXSession();
        session.getHttpClient().getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        AJAXClient myClient = new AJAXClient(session);
        try {
            TokenLoginResponse response = myClient.execute(new TokenLoginRequest(this.login, this.password));
            TokenLoginTest.assertNotNull((String)"Path of redirect response is not found.", (Object)response.getPath());
            TokenLoginTest.assertNotNull((String)"Server side token not found as fragment.", (Object)response.getServerToken());
            TokenLoginTest.assertNotNull((String)"Login string was not found as fragment.", (Object)response.getLogin());
            TokenLoginTest.assertNotSame((String)"", (Object)Autoboxing.I((int)-1), (Object)Autoboxing.I((int)response.getUserId()));
            TokenLoginTest.assertNotNull((String)"Language string was not found as fragment.", (Object)response.getLanguage());
            TokensResponse response2 = myClient.execute(new TokensRequest(response.getHttpSessionId(), response.getClientToken(), response.getServerToken()));
            session.setId(response2.getSessionId());
            int userId = myClient.execute(new GetRequest(Tree.Identifier)).getInteger();
            TokenLoginTest.assertTrue((String)"Users identifier is somehow wrong. Check if session is correctly activated.", (userId > 2 ? 1 : 0) != 0);
        }
        finally {
            myClient.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionExpire() throws Exception {
        AJAXSession session = new AJAXSession();
        AJAXClient myClient = new AJAXClient(session);
        try {
            TokenLoginResponse response = myClient.execute(new TokenLoginRequest(this.login, this.password));
            TokenLoginTest.assertNotNull((String)"Path of redirect response is not found.", (Object)response.getPath());
            TokenLoginTest.assertNotNull((String)"Server side token not found as fragment.", (Object)response.getServerToken());
            TokenLoginTest.assertNotNull((String)"Login string was not found as fragment.", (Object)response.getLogin());
            TokenLoginTest.assertNotSame((String)"", (Object)Autoboxing.I((int)-1), (Object)Autoboxing.I((int)response.getUserId()));
            TokenLoginTest.assertNotNull((String)"Language string was not found as fragment.", (Object)response.getLanguage());
            Thread.sleep(60000L);
            TokensResponse response2 = myClient.execute(new TokensRequest(response.getHttpSessionId(), response.getClientToken(), response.getServerToken(), false));
            TokenLoginTest.assertTrue((String)"Tokened session should be expired.", (boolean)response2.hasError());
            OXException expected = OXExceptionFactory.getInstance().create((OXExceptionCode)SessionExceptionCodes.NO_SESSION_FOR_SERVER_TOKEN);
            OXException actual = response2.getException();
            TokenLoginTest.assertTrue((String)"Wrong exception", (boolean)actual.similarTo(expected));
        }
        finally {
            myClient.logout();
        }
    }
}

