/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.resource.actions.ResourceAllRequest;
import com.openexchange.ajax.resource.actions.ResourceAllResponse;
import com.openexchange.ajax.resource.actions.ResourceListRequest;
import com.openexchange.ajax.resource.actions.ResourceListResponse;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ResourceTools {
    private static final Random rand = new Random(System.currentTimeMillis());

    private ResourceTools() {
    }

    private static int[] getAllResourceIds(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        ResourceAllRequest request = new ResourceAllRequest();
        ResourceAllResponse response = client.execute(request);
        return response.getIDs();
    }

    private static List<Resource> getResources(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        ResourceListRequest listReq = new ResourceListRequest(ResourceTools.getAllResourceIds(client));
        ResourceListResponse listResp = client.execute(listReq);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : listResp.getResources()) {
            resources.add(resource);
        }
        return resources;
    }

    public static int getSomeResource(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        int[] resourceIds = ResourceTools.getAllResourceIds(client);
        return resourceIds[rand.nextInt(resourceIds.length)];
    }

    public static List<Resource> getResources(AJAXClient client, int count) throws OXException, IOException, SAXException, JSONException {
        List<Resource> resource = ResourceTools.getResources(client);
        resource = ResourceTools.extractByRandom(resource, count);
        return resource;
    }

    public static List<Resource> extractByRandom(List<Resource> resources, int count) {
        ArrayList<Resource> retval = new ArrayList<Resource>();
        do {
            Resource resource;
            if (retval.contains(resource = resources.get(rand.nextInt(resources.size())))) continue;
            retval.add(resource);
        } while (retval.size() < count && retval.size() < resources.size());
        return retval;
    }
}

