/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.importexport.ImportResult;
import java.util.Calendar;

public class Bug20718Test_JumpDuringDstCrossing
extends ManagedAppointmentTest {
    public Bug20718Test_JumpDuringDstCrossing(String name) {
        super(name);
    }

    private String ical(String tzid) {
        return "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 14.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VTIMEZONE\nTZID:Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, Wien\nBEGIN:STANDARD\nDTSTART:16011028T030000\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nEND:STANDARD\nBEGIN:DAYLIGHT\nDTSTART:16010325T020000\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nEND:DAYLIGHT\nEND:VTIMEZONE\n\nBEGIN:VEVENT\nCLASS:PUBLIC\nDTEND;TZID=\"" + tzid + "\":20081009T170000\n" + "DTSTART;TZID=\"Amsterdam, Berlin, Bern, Rom, Stockholm, Wien\":20081009T130000\n" + "RRULE:FREQ=WEEKLY;BYDAY=TH\n" + "SUMMARY:geblockt f\u00fcr Prof. Bruce-Boye - keine Termine\n" + "UID:AAAAAGQnWJsQLItElPc+mdUPXr/kSyMA\n" + "END:VEVENT\n" + "END:VCALENDAR";
    }

    public void testOriginalOutlookCase() throws Exception {
        this.doTest("Amsterdam, Berlin, Bern, Rom, Stockholm, Wien");
    }

    public void testRegression1() throws Exception {
        this.doTest("Zulu");
    }

    public void testRegression2() throws Exception {
        this.doTest("Europe/Berlin");
    }

    public void doTest(String tzid) throws Exception {
        ICalImportRequest impRequest = new ICalImportRequest(this.folder.getObjectID(), this.ical(tzid));
        ICalImportResponse impResponse = this.getClient().execute(impRequest);
        Bug20718Test_JumpDuringDstCrossing.assertFalse((boolean)impResponse.hasError());
        ImportResult[] imports = impResponse.getImports();
        Bug20718Test_JumpDuringDstCrossing.assertEquals((int)1, (int)imports.length);
        int objectID = Integer.parseInt(imports[0].getObjectId());
        Appointment summer = this.calendarManager.get(this.folder.getObjectID(), objectID, 1);
        Appointment winter = this.calendarManager.get(this.folder.getObjectID(), objectID, 4);
        Calendar cal = Calendar.getInstance();
        cal.setTime(summer.getStartDate());
        int summerStart = cal.get(11);
        cal.setTime(winter.getStartDate());
        int winterStart = cal.get(11);
        Bug20718Test_JumpDuringDstCrossing.assertEquals((int)summerStart, (int)winterStart);
    }
}

