/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;

public class YomiContactSearchTests
extends AbstractManagedContactTest {
    private static final String YOMI_LAST_NAME = "\u4f50\u85e4";
    protected static final String YOMI_FIRST_NAME = "\u660e\u65e5\u9999";
    private Contact contact;

    public YomiContactSearchTests(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.contact = new Contact();
        this.contact.setTitle("Herr");
        this.contact.setGivenName("Baab");
        this.contact.setSurName("Abba");
        this.contact.setDisplayName("Baab Abba");
        this.contact.setStreetBusiness("Franz-Meier Weg 17");
        this.contact.setCityBusiness("Test Stadt");
        this.contact.setStateBusiness("NRW");
        this.contact.setCountryBusiness("Deutschland");
        this.contact.setTelephoneBusiness1("+49112233445566");
        this.contact.setCompany("Internal Test AG");
        this.contact.setEmail1("baab.abba@open-foobar.com");
        this.contact.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
        this.contact.setYomiFirstName(YOMI_FIRST_NAME);
        this.contact.setYomiLastName(YOMI_LAST_NAME);
        this.contact.setParentFolderID(this.folderID);
        this.manager.newAction(this.contact);
        System.out.println();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFindWithContactSearchObject() {
        ContactSearchObject search = new ContactSearchObject();
        search.setFolder(this.folderID);
        String b = YOMI_LAST_NAME;
        search.setGivenName(b);
        search.setSurname(b);
        search.setDisplayName(b);
        search.setEmail1(b);
        search.setEmail2(b);
        search.setEmail3(b);
        search.setCatgories(b);
        search.setYomiFirstname(b);
        search.setYomiLastName(b);
        search.setOrSearch(true);
        Contact[] results = this.manager.searchAction(search);
        YomiContactSearchTests.assertEquals((String)"Should find one contact", (int)1, (int)results.length);
        YomiContactSearchTests.assertEquals((String)"Should find the right contact", (String)YOMI_LAST_NAME, (String)results[0].getYomiLastName());
    }
}

