/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.Expectations;

public class TestsToCreateMinimalAppointmentSeries
extends ManagedAppointmentTest {
    public TestsToCreateMinimalAppointmentSeries(String name) {
        super(name);
    }

    public void _testShouldFailWhenSendingUnneccessaryDayInformationForDailyAppointment() throws Exception {
        TestsToCreateMinimalAppointmentSeries.fail((String)"Fails until an independent parser/writer is used for creating JSON-Objects");
        Changes changes = new Changes();
        changes.put(209, (Object)1);
        changes.put(222, (Object)7);
        changes.put(215, (Object)1);
        changes.put(212, (Object)127);
        this.negativeAssertionOnCreate.check(changes, new OXException(998));
        this.negativeAssertionOnUpdate.check(changes, new OXException(999));
    }

    public void testShouldCreateDailyIntervalWithMinimalData() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)1);
        changes.put(215, (Object)1);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldCreateWeeklyIntervalWithMinimalData() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)2);
        changes.put(215, (Object)1);
        Expectations expectations = new Expectations(changes);
        expectations.put(212, (Object)127);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldCreateWeeklyIntervalWithDaysFieldDifferentThan127() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)2);
        changes.put(215, (Object)1);
        changes.put(212, (Object)6);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldFailCreatingMonthlyIntervalWithoutDayInMonthInfo() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(215, (Object)1);
        this.negativeAssertionOnCreate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
        this.negativeAssertionOnUpdate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
    }

    public void testShouldFailCreatingMonthly2IntervalWithoutDayInMonthInfo() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(215, (Object)1);
        changes.put(212, (Object)2);
        this.negativeAssertionOnCreate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
        this.negativeAssertionOnUpdate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
    }

    public void testShouldCreateMonthlyIntervalWithMinimalData() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldCreateMonthly2IntervalWithMinimalData() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)3);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        changes.put(212, (Object)2);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldFailCreatingYearlyIntervalWithoutDayInMonthInfo() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(215, (Object)1);
        this.negativeAssertionOnCreate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
        this.negativeAssertionOnUpdate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
    }

    public void testShouldFailCreatingYearly2IntervalWithoutDayInMonthInfo() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(215, (Object)1);
        changes.put(212, (Object)2);
        this.negativeAssertionOnCreate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
        this.negativeAssertionOnUpdate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_MONTHDAY.create());
    }

    public void testShouldFailCreatingYearlyIntervalWithoutMonth() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        this.negativeAssertionOnCreate.check(changes, OXCalendarExceptionCodes.RECURRING_MISSING_YEARLY_MONTH.create());
        this.negativeAssertionOnUpdate.check(changes, OXCalendarExceptionCodes.RECURRING_MISSING_YEARLY_MONTH.create());
    }

    public void testShouldCreateYearlyIntervalWithMinimalData() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        changes.put(214, (Object)0);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldCreateYearly2IntervalWithMinimalData() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        changes.put(212, (Object)2);
        changes.put(214, (Object)0);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreate.check(changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(changes, new Expectations(changes));
    }

    public void testShouldFailCreatingIntervalWithoutIntervalInformation() throws Exception {
        Changes changes = new Changes();
        changes.put(209, (Object)1);
        this.negativeAssertionOnCreate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_INTERVAL.create());
        this.negativeAssertionOnUpdate.check(changes, OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_INTERVAL.create());
    }
}

