/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;

public class TestsForModifyingChangeExceptions
extends ManagedAppointmentTest {
    private final int exceptionPosition = 2;
    private Changes changes;
    private Appointment update;
    private Appointment app;

    public TestsForModifyingChangeExceptions(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.app = this.generateDailyAppointment();
        this.app.setOccurrence(3);
        this.calendarManager.insert(this.app);
        this.changes = new Changes();
        this.changes.put(207, (Object)2);
        this.changes.put(201, (Object)this.D("2/1/2008 1:00", this.utc));
        this.changes.put(202, (Object)this.D("2/1/2008 2:00", this.utc));
        this.update = this.app.clone();
        this.changes.update((CommonObject)this.update);
        this.calendarManager.update(this.update);
    }

    public void testShouldNotAllowTurningAChangeExceptionIntoASeries() {
        Changes secondChange = new Changes();
        secondChange.put(209, (Object)1);
        secondChange.put(215, (Object)1);
        Appointment secondUpdate = new Appointment();
        secondUpdate.setParentFolderID(this.update.getParentFolderID());
        secondUpdate.setObjectID(this.update.getObjectID());
        secondUpdate.setLastModified(this.update.getLastModified());
        secondChange.update((CommonObject)secondUpdate);
        this.calendarManager.update(secondUpdate);
        TestsForModifyingChangeExceptions.assertTrue((String)"Should get exception when trying to make a change exception a series", (boolean)this.calendarManager.hasLastException());
        TestsForModifyingChangeExceptions.assertEquals((String)"Should have correct exception", (int)99, (int)((OXException)((Object)this.calendarManager.getLastException())).getCode());
    }

    public void testDeletingAChangeException() {
        Appointment secondUpdate = new Appointment();
        secondUpdate.setParentFolderID(this.update.getParentFolderID());
        secondUpdate.setObjectID(this.update.getObjectID());
        secondUpdate.setLastModified(this.update.getLastModified());
        secondUpdate.setRecurrencePosition(2);
        secondUpdate.setRecurrenceType(3);
        this.calendarManager.delete(secondUpdate);
        TestsForModifyingChangeExceptions.assertFalse((String)"Should get no error when trying to delete a change exception", (boolean)this.calendarManager.hasLastException());
    }
}

