/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.Expectations;

public class TestsForDifferentWaysOfEndingASeries
extends ManagedAppointmentTest {
    public TestsForDifferentWaysOfEndingASeries(String name) {
        super(name);
    }

    public void testShouldNotSetUntilIfOccurrencesIsUsed() throws Exception {
        Appointment app = this.generateDailyAppointment();
        Changes changes = new Changes();
        changes.put(222, (Object)7);
        changes.put(209, app.get(209));
        changes.put(215, app.get(215));
        Expectations expectations = new Expectations(changes);
        expectations.put(216, null);
        this.positiveAssertionOnCreate.check(app, changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldNotSetOccurrencesIfUntilIsUsed() throws Exception {
        Appointment app = this.generateDailyAppointment();
        Changes changes = new Changes();
        changes.put(216, (Object)this.D("7/1/2008 00:00"));
        changes.put(209, app.get(209));
        changes.put(215, app.get(215));
        Expectations expectations = new Expectations(changes);
        expectations.put(222, null);
        this.positiveAssertionOnCreate.check(app, changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldNotSetOccurrencesIfNothingIsSet() throws Exception {
        Appointment app = this.generateDailyAppointment();
        Changes changes = new Changes();
        changes.put(209, app.get(209));
        changes.put(215, app.get(215));
        Expectations expectations = new Expectations(changes);
        expectations.put(222, null);
        expectations.put(216, null);
        this.positiveAssertionOnCreate.check(app, changes, expectations);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }
}

