/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class NewListTest
extends AbstractAJAXSession {
    private static final int NUMBER = 10;
    private static final int DELETES = 2;

    public NewListTest(String name) {
        super(name);
    }

    public void testRemovedObjectHandling() throws Throwable {
        AJAXClient clientA = this.getClient();
        TimeZone tzA = clientA.getValues().getTimeZone();
        int folderA = clientA.getValues().getPrivateAppointmentFolder();
        Date appStart = new Date(TimeTools.getHour(0, tzA));
        Date appEnd = new Date(TimeTools.getHour(1, tzA));
        Date listStart = new Date(TimeTools.getHour(-1, tzA));
        Date listEnd = new Date(TimeTools.getHour(2, tzA));
        InsertRequest[] inserts = new InsertRequest[10];
        for (int i = 0; i < inserts.length; ++i) {
            Appointment app = new Appointment();
            app.setTitle("New List Test " + (i + 1));
            app.setParentFolderID(folderA);
            app.setStartDate(appStart);
            app.setEndDate(appEnd);
            app.setIgnoreConflicts(true);
            app.addParticipant((Participant)new UserParticipant(clientA.getValues().getUserId()));
            inserts[i] = new InsertRequest(app, tzA);
        }
        MultipleResponse mInsert = (MultipleResponse)clientA.execute(MultipleRequest.create(inserts));
        ArrayList toDelete = new ArrayList(10);
        Iterator iter = mInsert.iterator();
        while (iter.hasNext()) {
            toDelete.add(iter.next());
        }
        int[] columns = new int[]{200, 1, 20};
        CommonAllResponse allR = clientA.execute(new AllRequest(folderA, columns, listStart, listEnd, tzA));
        DeleteRequest[] deletes1 = new DeleteRequest[2];
        for (int i = 0; i < deletes1.length; ++i) {
            CommonInsertResponse insertR = (CommonInsertResponse)((Object)toDelete.remove(4 + i));
            deletes1[i] = new DeleteRequest(insertR.getId(), folderA, allR.getTimestamp());
        }
        clientA.execute(MultipleRequest.create(deletes1));
        CommonListResponse listR = clientA.execute(new ListRequest(allR.getListIDs(), columns, true));
        DeleteRequest[] deletes2 = new DeleteRequest[toDelete.size()];
        for (int i = 0; i < deletes2.length; ++i) {
            CommonInsertResponse insertR = (CommonInsertResponse)((Object)toDelete.get(i));
            deletes2[i] = new DeleteRequest(insertR.getId(), folderA, listR.getTimestamp());
        }
        clientA.execute(MultipleRequest.create(deletes2));
    }
}

