/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.HasRequest;
import com.openexchange.ajax.appointment.action.HasResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class HasTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;

    public HasTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.tz = this.client.getValues().getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHasAppointment() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 9);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int hasInterval = 7;
        Date start = c.getTime();
        c.add(5, 7);
        Date end = c.getTime();
        Appointment appointment = new Appointment();
        appointment.setTitle("testHasAppointment");
        c.setTime(start);
        int posInArray = 3;
        c.add(5, 3);
        appointment.setStartDate(c.getTime());
        c.add(10, 1);
        appointment.setEndDate(c.getTime());
        appointment.setShownAs(3);
        appointment.setParentFolderID(this.folderId);
        appointment.setIgnoreConflicts(true);
        AppointmentInsertResponse insertR = this.client.execute(new InsertRequest(appointment, this.tz));
        insertR.fillAppointment(appointment);
        try {
            HasResponse hasR = this.client.execute(new HasRequest(start, end, this.tz));
            boolean[] hasAppointments = hasR.getValues();
            HasTest.assertEquals((String)"Length of array of action has is wrong.", (int)7, (int)hasAppointments.length);
            HasTest.assertEquals((String)"Inserted appointment not found in action has response.", (boolean)hasAppointments[3], (boolean)true);
        }
        finally {
            this.client.execute(new DeleteRequest(appointment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHasAppointmentFullTime() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int hasInterval = 7;
        Date start = c.getTime();
        c.add(5, 7);
        Date end = c.getTime();
        Appointment appointment = new Appointment();
        appointment.setTitle("testHasAppointmentFullTime");
        c.setTime(start);
        int posInArray = 3;
        c.add(5, 3);
        appointment.setStartDate(c.getTime());
        c.add(5, 1);
        appointment.setEndDate(c.getTime());
        appointment.setShownAs(3);
        appointment.setFullTime(true);
        appointment.setParentFolderID(this.folderId);
        appointment.setIgnoreConflicts(true);
        AppointmentInsertResponse insertR = this.client.execute(new InsertRequest(appointment, this.tz));
        insertR.fillAppointment(appointment);
        try {
            HasResponse hasR = this.client.execute(new HasRequest(start, end, this.tz));
            boolean[] hasAppointments = hasR.getValues();
            HasTest.assertEquals((String)"Length of array of action has is wrong.", (int)7, (int)hasAppointments.length);
            HasTest.assertEquals((String)"Inserted appointment not found in action has response.", (boolean)hasAppointments[3], (boolean)true);
        }
        finally {
            this.client.execute(new DeleteRequest(appointment));
        }
    }
}

