/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.database;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class FixSubscriptionTablePrimaryKey
extends UpdateTaskAdapter {
    private static final String TABLE = "subscriptions";
    private static final String[] COLUMNS = new String[]{"cid", "id"};
    private final DatabaseService dbService;

    public FixSubscriptionTablePrimaryKey(DatabaseService service) {
        this.dbService = service;
    }

    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.CreateSubscribeTableTask"};
    }

    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = this.dbService.getForUpdateTask(cid);
        try {
            con.setAutoCommit(false);
            if (!Tools.existsPrimaryKey((Connection)con, (String)TABLE, (String[])COLUMNS)) {
                Tools.dropPrimaryKey((Connection)con, (String)TABLE);
                Tools.createPrimaryKey((Connection)con, (String)TABLE, (String[])COLUMNS);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback((Connection)con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            DBUtils.autocommit((Connection)con);
            this.dbService.backForUpdateTask(cid, con);
        }
    }
}

