/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.utility;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.api2.TasksSQLInterface;
import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.versit.Versit;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;

public final class VersitUtility {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(VersitUtility.class));
    private static final String VERSIT_VTODO = "VTODO";
    private static final String VERSIT_VEVENT = "VEVENT";

    private VersitUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVCard(InputStream vcardInputStream, String baseContentType, String charset, List<CommonObject> retvalList, Session session, Context ctx) throws IOException, ConverterException, OXException {
        VersitDefinition def = Versit.getDefinition(baseContentType);
        VersitDefinition.Reader r = def.getReader(vcardInputStream, charset);
        OXContainerConverter oxc = null;
        try {
            oxc = new OXContainerConverter(session);
            VersitObject vo = def.parse(r);
            if (vo != null) {
                Contact contactObj = oxc.convertContact(vo);
                contactObj.setParentFolderID(new OXFolderAccess(ctx).getDefaultFolder(session.getUserId(), 3).getObjectID());
                contactObj.setContextId(ctx.getContextId());
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                contactService.createContact(session, Integer.toString(contactObj.getParentFolderID()), contactObj);
                retvalList.add(contactObj);
            }
        }
        finally {
            if (oxc != null) {
                oxc.close();
                oxc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveICal(InputStream icalInputStream, String baseContentType, String charset, List<CommonObject> retvalList, Session session, Context ctx) throws IOException, ConverterException, OXException {
        VersitDefinition def = Versit.getDefinition(baseContentType);
        VersitDefinition.Reader r = def.getReader(icalInputStream, charset);
        OXContainerConverter oxc = null;
        AppointmentSQLInterface appointmentInterface = null;
        TasksSQLInterface taskInterface = null;
        try {
            oxc = new OXContainerConverter(session);
            VersitObject rootVersitObj = def.parseBegin(r);
            VersitObject vo = null;
            int defaultCalendarFolder = -1;
            int defaultTaskFolder = -1;
            OXFolderAccess access = new OXFolderAccess(ctx);
            while ((vo = def.parseChild(r, rootVersitObj)) != null) {
                if (VERSIT_VEVENT.equals(vo.name)) {
                    CalendarDataObject appointmentObj = oxc.convertAppointment(vo);
                    appointmentObj.setContext(ctx);
                    if (defaultCalendarFolder == -1) {
                        defaultCalendarFolder = access.getDefaultFolder(session.getUserId(), 2).getObjectID();
                    }
                    appointmentObj.setParentFolderID(defaultCalendarFolder);
                    if (appointmentInterface == null) {
                        appointmentInterface = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                    }
                    appointmentInterface.insertAppointmentObject(appointmentObj);
                    retvalList.add(appointmentObj);
                    continue;
                }
                if (VERSIT_VTODO.equals(vo.name)) {
                    Task taskObj = oxc.convertTask(vo);
                    if (defaultTaskFolder == -1) {
                        defaultTaskFolder = access.getDefaultFolder(session.getUserId(), 1).getObjectID();
                    }
                    taskObj.setParentFolderID(defaultTaskFolder);
                    if (taskInterface == null) {
                        taskInterface = new TasksSQLImpl(session);
                    }
                    taskInterface.insertTaskObject(taskObj);
                    retvalList.add(taskObj);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("invalid versit object: " + vo.name));
            }
        }
        finally {
            if (oxc != null) {
                oxc.close();
                oxc = null;
            }
        }
    }
}

