/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.treeconsistency;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.cache.impl.FolderQueryCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.oxfolder.treeconsistency.CheckPermission;
import com.openexchange.tools.oxfolder.treeconsistency.ToDoPermission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.osgi.service.event.EventAdmin;

public final class CheckPermissionOnInsert
extends CheckPermission {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CheckPermissionOnInsert.class));

    public CheckPermissionOnInsert(Session session, Connection writeCon, Context ctx) {
        super(session, writeCon, ctx);
    }

    public void checkParentPermissions(int parent, OCLPermission[] perms, long lastModified) throws OXException {
        block14: {
            try {
                HashMap<Integer, ToDoPermission> map = new HashMap<Integer, ToDoPermission>();
                for (int i = 0; i < perms.length; ++i) {
                    OCLPermission assignedPerm = perms[i];
                    if (!assignedPerm.isFolderVisible()) continue;
                    this.ensureParentVisibility(parent, assignedPerm.getEntity(), assignedPerm.isGroupPermission(), map);
                }
                if (map.isEmpty()) break block14;
                int mapSize = map.size();
                Iterator mapIterator = map.entrySet().iterator();
                for (int i = 0; i < mapSize; ++i) {
                    Map.Entry entry = mapIterator.next();
                    int folderId = (Integer)entry.getKey();
                    int[] users = ((ToDoPermission)entry.getValue()).getUsers();
                    for (int j = 0; j < users.length; ++j) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Auto-Insert system-folder-read permission for user " + UserStorage.getStorageUser(users[j], this.ctx).getDisplayName() + " to folder " + folderId));
                        }
                        this.addSystemFolderReadPermission(folderId, users[j], false);
                    }
                    int[] groups = ((ToDoPermission)entry.getValue()).getGroups();
                    for (int j = 0; j < groups.length; ++j) {
                        if (LOG.isDebugEnabled()) {
                            try {
                                LOG.debug((Object)("Auto-Insert system-folder-read permission for group " + GroupStorage.getInstance().getGroup(groups[j], this.ctx).getDisplayName() + " to folder " + folderId));
                            }
                            catch (OXException e) {
                                LOG.trace((Object)"Logging failed", (Throwable)e);
                            }
                        }
                        this.addSystemFolderReadPermission(folderId, groups[j], true);
                    }
                    OXFolderSQL.updateLastModified(folderId, lastModified, this.ctx.getMailadmin(), this.writeCon, this.ctx);
                    ConditionTreeMapManagement.dropFor(this.ctx.getContextId());
                    try {
                        if (FolderCacheManager.isEnabled()) {
                            FolderCacheManager.getInstance().removeFolderObject(folderId, this.ctx);
                        }
                        this.broadcastEvent(folderId, true, ServerServiceRegistry.getInstance().getService(EventAdmin.class));
                        if (FolderQueryCacheManager.isInitialized()) {
                            FolderQueryCacheManager.getInstance().invalidateContextQueries(this.session);
                        }
                        if (!CalendarCache.isInitialized()) continue;
                        CalendarCache.getInstance().invalidateGroup(this.ctx.getContextId());
                        continue;
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
    }

    private void ensureParentVisibility(int parent, int entity, boolean isGroup, Map<Integer, ToDoPermission> map) throws OXException, OXException, SQLException {
        if (parent < 20) {
            return;
        }
        FolderObject parentFolder = this.getFolderFromMaster(parent);
        if (!CheckPermissionOnInsert.containsSystemPermission(parentFolder.getPermissions(), entity)) {
            Integer key = parent;
            ToDoPermission todo = map.get(key);
            if (todo == null) {
                todo = new ToDoPermission(parent);
                map.put(key, todo);
            }
            if (isGroup) {
                todo.addGroup(entity);
            } else {
                todo.addUser(entity);
            }
        }
        this.ensureParentVisibility(parentFolder.getParentFolderID(), entity, isGroup, map);
    }

    private void addSystemFolderReadPermission(int folderId, int entity, boolean isGroup) throws OXException, SQLException {
        OXFolderSQL.addSinglePermission(folderId, entity, isGroup, 2, 0, 0, 0, false, 1, this.writeCon, this.ctx);
    }
}

