/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.oxfolder.OXFolderBatchLoader;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.memory.Condition;
import com.openexchange.tools.oxfolder.memory.ConditionTree;
import com.openexchange.tools.oxfolder.memory.Permission;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.ConcurrentTIntObjectHashMap;
import gnu.trove.EmptyTIntSet;
import gnu.trove.TIntCollection;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ConditionTreeMap {
    private static final EmptyTIntSet EMPTY_SET = EmptyTIntSet.getInstance();
    private final ConcurrentTIntObjectHashMap<ConditionTree> trees = new ConcurrentTIntObjectHashMap(1024);
    private final int contextId;
    protected final long stamp;

    public ConditionTreeMap(int contextId) {
        this.contextId = contextId;
        this.stamp = System.currentTimeMillis();
    }

    public void init() throws OXException {
        this.trees.clear();
        DatabaseService service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = service.getReadOnly(this.contextId);
            stmt = connection.prepareStatement("SELECT ot.fuid, op.permission_id, op.admin_flag, op.fp, ot.module, ot.type, ot.created_from, ot.changing_date, ot.parent FROM oxfolder_tree AS ot JOIN oxfolder_permissions AS op ON ot.cid = op.cid AND ot.fuid = op.fuid WHERE ot.cid = ?");
            stmt.setInt(1, this.contextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Permission p = new Permission();
                int pos = 1;
                p.fuid = rs.getInt(pos++);
                p.entity = rs.getInt(pos++);
                p.admin = rs.getInt(pos++) > 0;
                p.readFolder = rs.getInt(pos++) >= 2;
                p.module = rs.getInt(pos++);
                p.type = rs.getInt(pos++);
                p.creator = rs.getInt(pos++);
                p.lastModified = rs.getLong(pos++);
                p.parent = rs.getInt(pos);
                this.insert(p);
            }
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != connection) {
                    service.backReadOnly(this.contextId, connection);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != connection) {
            service.backReadOnly(this.contextId, connection);
        }
    }

    public void clear() {
        this.trees.clear();
    }

    public void removeFor(int entity) {
        this.trees.remove(entity);
    }

    public void insert(Permission permission) {
        ConditionTree newTree;
        int entity = permission.entity;
        ConditionTree tree = (ConditionTree)this.trees.get(entity);
        if (null == tree && null == (tree = (ConditionTree)this.trees.putIfAbsent(entity, (Object)(newTree = new ConditionTree())))) {
            tree = newTree;
        }
        tree.insert(permission);
    }

    public TIntSet getVisibleForUser(int userId, int[] groups, int[] accessibleModules, Condition ... conditions) {
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return EMPTY_SET;
        }
        CombinedCondition condition = new CombinedCondition((Condition)new ModulesCondition(accessibleModules), conditions);
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree) continue;
                set.addAll((TIntCollection)gtree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public TIntSet getVisibleForUser(int userId, int[] groups, int[] accessibleModules, Collection<Condition> conditions) {
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return EMPTY_SET;
        }
        CombinedCondition condition = new CombinedCondition(new ModulesCondition(accessibleModules), conditions);
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree) continue;
                set.addAll((TIntCollection)gtree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public boolean isVisibleFolder(int userId, int[] groups, int[] accessibleModules, int folderId) {
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return false;
        }
        ModulesCondition condition = new ModulesCondition(accessibleModules);
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (!set.isEmpty() && set.contains(folderId)) {
            return true;
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree || (set = gtree.getVisibleFolderIds(condition)).isEmpty() || !set.contains(folderId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSharedFolder(int userId, int[] groups, int[] accessibleModules) {
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return false;
        }
        CombinedCondition condition = new CombinedCondition((Condition)new ModulesCondition(accessibleModules), new TypeCondition(3, userId));
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (!set.isEmpty()) {
            return true;
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree || gtree.getVisibleFolderIds(condition).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public TIntSet getVisibleTypeForUser(int userId, int[] groups, int[] accessibleModules, int type) {
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return EMPTY_SET;
        }
        CombinedCondition condition = new CombinedCondition((Condition)new ModulesCondition(accessibleModules), new TypeCondition(type, userId));
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree) continue;
                set.addAll((TIntCollection)gtree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public TIntSet getVisibleModuleForUser(int userId, int[] groups, int[] accessibleModules, int module) {
        TIntHashSet modules;
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return EMPTY_SET;
        }
        if (null != accessibleModules && !(modules = new TIntHashSet(accessibleModules)).contains(module)) {
            return EMPTY_SET;
        }
        CombinedCondition condition = new CombinedCondition(new ModuleCondition(module), new Condition[0]);
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree) continue;
                set.addAll((TIntCollection)gtree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public TIntSet getVisibleForUser(int userId, int[] groups, int[] accessibleModules, int module, int type) {
        TIntHashSet modules;
        ConditionTree tree = (ConditionTree)this.trees.get(userId);
        if (null == tree) {
            return EMPTY_SET;
        }
        if (null != accessibleModules && !(modules = new TIntHashSet(accessibleModules)).contains(module)) {
            return EMPTY_SET;
        }
        CombinedCondition condition = new CombinedCondition(new ModuleCondition(module), new TypeCondition(type, userId));
        TIntSet set = tree.getVisibleFolderIds(condition);
        if (null != groups) {
            for (int group : groups) {
                ConditionTree gtree = (ConditionTree)this.trees.get(group);
                if (null == gtree) continue;
                set.addAll((TIntCollection)gtree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public static List<FolderObject> asList(TIntSet set, Context ctx) throws OXException {
        return ConditionTreeMap.asList(set, ctx, null);
    }

    public static List<FolderObject> asList(TIntSet set, Context ctx, Connection con) throws OXException {
        if (null == set || set.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            TIntObjectHashMap m = new TIntObjectHashMap(set.size());
            TIntHashSet toLoad = new TIntHashSet((TIntCollection)set);
            FolderCacheManager cacheManager = FolderCacheManager.getInstance();
            boolean cacheEnabled = FolderCacheManager.isEnabled();
            if (cacheEnabled) {
                for (FolderObject fo : cacheManager.getTrimedFolderObjects(set.toArray(), ctx)) {
                    int objectID = fo.getObjectID();
                    toLoad.remove(objectID);
                    m.put(objectID, (Object)fo);
                }
            }
            if (!toLoad.isEmpty()) {
                if (null == con) {
                    ConditionTreeMap.loadBy((TIntSet)toLoad, (TIntObjectMap<FolderObject>)m, cacheEnabled, cacheManager, ctx);
                } else {
                    ConditionTreeMap.loadBy((TIntSet)toLoad, (TIntObjectMap<FolderObject>)m, cacheEnabled, cacheManager, ctx, con);
                }
            }
            ArrayList<FolderObject> list = new ArrayList<FolderObject>(m.size());
            TIntProcedure procedure = new TIntProcedure((TIntObjectMap)m, list){
                final /* synthetic */ TIntObjectMap val$m;
                final /* synthetic */ List val$list;
                {
                    this.val$m = tIntObjectMap;
                    this.val$list = list;
                }

                public boolean execute(int folderId) {
                    try {
                        FolderObject fo = (FolderObject)this.val$m.get(folderId);
                        if (null != fo) {
                            this.val$list.add(fo);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        throw new ProcedureFailedException(e);
                    }
                }
            };
            set.forEach(procedure);
            return list;
        }
        catch (ProcedureFailedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(cause, cause.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBy(TIntSet toLoad, TIntObjectMap<FolderObject> m, boolean cacheEnabled, FolderCacheManager cacheManager, Context ctx) throws OXException {
        DatabaseService service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = null;
        try {
            con = service.getReadOnly(ctx);
            ConditionTreeMap.loadBy(toLoad, m, cacheEnabled, cacheManager, ctx, con);
        }
        finally {
            if (null != con) {
                service.backReadOnly(ctx, con);
            }
        }
    }

    private static void loadBy(TIntSet toLoad, TIntObjectMap<FolderObject> m, boolean cacheEnabled, final FolderCacheManager cacheManager, final Context ctx, Connection con) throws OXException {
        if (null == con) {
            ConditionTreeMap.loadBy(toLoad, m, cacheEnabled, cacheManager, ctx);
            return;
        }
        List<FolderObject> loaded = OXFolderBatchLoader.loadFolderObjectsFromDB(toLoad.toArray(), ctx, con, true, true);
        if (cacheEnabled) {
            final ArrayList<FolderObject> tmp = new ArrayList<FolderObject>(loaded);
            ThreadPools.getThreadPool().submit((Task)new AbstractTask<Void>(){

                public Void call() throws Exception {
                    for (FolderObject fo : tmp) {
                        if (null == fo) continue;
                        cacheManager.putFolderObject(fo, ctx, false, null);
                    }
                    return null;
                }
            });
        }
        for (FolderObject fo : loaded) {
            if (null == fo) continue;
            m.put(fo.getObjectID(), (Object)fo);
        }
    }

    protected static FolderObject getFolderObject(int folderId, Context ctx, Connection con) throws OXException {
        if (!FolderCacheManager.isEnabled()) {
            return FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
        }
        FolderCacheManager cacheManager = FolderCacheManager.getInstance();
        FolderObject fo = cacheManager.getFolderObject(folderId, ctx);
        if (null == fo) {
            fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
            cacheManager.putFolderObject(fo, ctx, false, null);
        }
        return fo;
    }

    private static final class ProcedureFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1821041261492515385L;

        public ProcedureFailedException(Throwable cause) {
            super(cause);
        }
    }

    public static final class LastModifiedCondition
    implements Condition {
        private final long lastModified;

        public LastModifiedCondition(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.lastModified > this.lastModified;
        }
    }

    public static final class ModulesCondition
    implements Condition {
        private final TIntSet accessibleModules;

        public ModulesCondition(int[] accessibleModules) {
            this.accessibleModules = new TIntHashSet(accessibleModules);
        }

        public ModulesCondition(TIntCollection accessibleModules) {
            this.accessibleModules = new TIntHashSet(accessibleModules);
        }

        @Override
        public boolean fulfilled(Permission p) {
            return this.accessibleModules.contains(p.module);
        }
    }

    public static final class ModuleCondition
    implements Condition {
        private final int module;

        public ModuleCondition(int module) {
            this.module = module;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return this.module == p.module;
        }
    }

    public static final class TypeCondition
    implements Condition {
        private final int type;
        private final int userId;

        public TypeCondition(int type, int userId) {
            if (3 == type) {
                this.userId = userId;
                this.type = 1;
            } else {
                this.userId = -1;
                this.type = type;
            }
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.type == this.type && (this.userId < 0 || p.creator != this.userId);
        }
    }

    public static final class CreatorCondition
    implements Condition {
        private final int creator;

        public CreatorCondition(int creator) {
            this.creator = creator;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.creator == this.creator;
        }
    }

    public static final class ParentCondition
    implements Condition {
        private final int parent;

        public ParentCondition(int parent) {
            this.parent = parent;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.parent == this.parent;
        }
    }

    public static final class PrivateCondition
    implements Condition {
        private final int userId;

        public PrivateCondition(int userId) {
            this.userId = userId;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return 1 == p.type && p.creator == this.userId;
        }
    }

    private static final class CombinedCondition
    implements Condition {
        private final List<Condition> conditions;

        protected CombinedCondition(Condition first, Condition ... others) {
            if (null != others) {
                this.conditions = new ArrayList<Condition>(others.length + 1);
                this.conditions.add(first);
                this.conditions.addAll(Arrays.asList(others));
            } else {
                this.conditions = new ArrayList<Condition>(1);
                this.conditions.add(first);
            }
        }

        public CombinedCondition(ModulesCondition first, Collection<Condition> conditions) {
            this.conditions = new ArrayList<Condition>(conditions.size() + 1);
            this.conditions.add(first);
            this.conditions.addAll(conditions);
        }

        @Override
        public boolean fulfilled(Permission p) {
            for (Condition condition : this.conditions) {
                if (condition.fulfilled(p)) continue;
                return false;
            }
            return true;
        }
    }
}

