/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import com.openexchange.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;

public final class Collections {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Collections.class));

    private Collections() {
    }

    public static <T> Iterator<T> unmodifiableIterator(final Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <T> T findFirst(Collection<T> collection, Filter<T> filter) {
        for (T object : collection) {
            if (!filter.accept(object)) continue;
            return object;
        }
        return null;
    }

    public static <T> void collect(Collection<T> input, Filter<T> filter, Collection<T> output) {
        for (T object : input) {
            if (!filter.accept(object)) continue;
            output.add(object);
        }
    }

    public static <T> boolean any(Collection<T> haystack, T ... needles) {
        for (T hay : haystack) {
            for (T needle : needles) {
                if (!(needle == null ? hay == null : needle.equals(hay))) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] toArray(Collection<Integer> col) {
        int[] retval = new int[col.size()];
        Iterator<Integer> iter = col.iterator();
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = iter.next();
        }
        return retval;
    }

    public static Object copy(Serializable orig) {
        try {
            FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fbos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(fbos.getInputStream());
            return in.readObject();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error((Object)cnfe.getMessage(), (Throwable)cnfe);
            return null;
        }
    }

    public static <T> Enumeration<T> iter2enum(Iterator<T> iter) {
        return new IteratorEnumeration<T>(iter);
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }

    private static class IteratorEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> iter;

        public IteratorEnumeration(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iter.next();
        }
    }

    public static class FastByteArrayInputStream
    extends InputStream {
        protected byte[] buf;
        protected int count;
        protected int pos;

        public FastByteArrayInputStream(byte[] buf, int count) {
            this.buf = new byte[buf.length];
            System.arraycopy(buf, 0, this.buf, 0, buf.length);
            this.count = count;
        }

        @Override
        public final int available() {
            return this.count - this.pos;
        }

        @Override
        public final int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public final int read(byte[] b, int off, int lenArg) {
            if (this.pos >= this.count) {
                return -1;
            }
            int len = lenArg;
            if (this.pos + len > this.count) {
                len = this.count - this.pos;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public final long skip(long nArg) {
            long n = nArg;
            if ((long)this.pos + n > (long)this.count) {
                n = this.count - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }
    }

    public static class FastByteArrayOutputStream
    extends OutputStream {
        protected byte[] buf;
        protected int size = 0;

        public FastByteArrayOutputStream() {
            this(5120);
        }

        public FastByteArrayOutputStream(int initSize) {
            this.buf = new byte[initSize];
        }

        private final void verifyBufferSize(int sz) {
            if (sz > this.buf.length) {
                byte[] old = this.buf;
                this.buf = new byte[Math.max(sz, 2 * this.buf.length)];
                System.arraycopy(old, 0, this.buf, 0, old.length);
            }
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getByteArray() {
            byte[] retval = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, retval, 0, this.buf.length);
            return retval;
        }

        @Override
        public final void write(byte[] b) {
            this.verifyBufferSize(this.size + b.length);
            System.arraycopy(b, 0, this.buf, this.size, b.length);
            this.size += b.length;
        }

        @Override
        public final void write(byte[] b, int off, int len) {
            this.verifyBufferSize(this.size + len);
            System.arraycopy(b, off, this.buf, this.size, len);
            this.size += len;
        }

        @Override
        public final void write(int b) {
            this.verifyBufferSize(this.size + 1);
            this.buf[this.size++] = (byte)b;
        }

        public void reset() {
            this.size = 0;
        }

        public InputStream getInputStream() {
            return new FastByteArrayInputStream(this.buf, this.size);
        }
    }

    public static class SmartLongArray {
        private int pointer;
        private long[] array;
        private final int growthSize;

        public SmartLongArray() {
            this(1024);
        }

        public SmartLongArray(int initialSize) {
            this(initialSize, initialSize >> 2);
        }

        public SmartLongArray(int initialSize, int growthSize) {
            this.growthSize = growthSize;
            this.array = new long[initialSize];
        }

        public SmartLongArray append(long i) {
            if (this.pointer >= this.array.length) {
                long[] tmpArray = new long[this.array.length + this.growthSize];
                System.arraycopy(this.array, 0, tmpArray, 0, this.array.length);
                this.array = tmpArray;
            }
            this.array[this.pointer++] = i;
            return this;
        }

        public long[] toArray() {
            long[] trimmedArray = new long[this.pointer];
            System.arraycopy(this.array, 0, trimmedArray, 0, trimmedArray.length);
            return trimmedArray;
        }

        public String toString() {
            return Arrays.toString(this.toArray());
        }
    }

    public static class SmartIntArray {
        private int pointer;
        private int[] array;
        private final int growthSize;

        public SmartIntArray() {
            this(1024);
        }

        public SmartIntArray(int initialSize) {
            this(initialSize, initialSize >> 2);
        }

        public SmartIntArray(int initialSize, int growthSize) {
            this.growthSize = growthSize;
            this.array = new int[initialSize];
        }

        public SmartIntArray append(int i) {
            if (this.pointer >= this.array.length) {
                int[] tmpArray = new int[this.array.length + this.growthSize];
                System.arraycopy(this.array, 0, tmpArray, 0, this.array.length);
                this.array = tmpArray;
            }
            this.array[this.pointer++] = i;
            return this;
        }

        public int[] toArray() {
            int[] trimmedArray = new int[this.pointer];
            System.arraycopy(this.array, 0, trimmedArray, 0, trimmedArray.length);
            return trimmedArray;
        }

        public String toString() {
            return Arrays.toString(this.toArray());
        }
    }
}

