/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.search;

import com.openexchange.search.Operand;
import com.openexchange.search.Operation;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.internal.terms.EqualsTerm;
import com.openexchange.search.internal.terms.GreaterOrEqualTerm;
import com.openexchange.search.internal.terms.GreaterThanTerm;
import com.openexchange.search.internal.terms.IsNullTerm;
import com.openexchange.search.internal.terms.LessOrEqualTerm;
import com.openexchange.search.internal.terms.LessThanTerm;
import com.openexchange.search.internal.terms.NotEqualTerm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SingleSearchTerm
implements SearchTerm<Operand<?>> {
    protected static final int DEFAULT_CAPACITY = 4;
    protected final SingleOperation operation;
    protected final List<Operand<?>> operands;

    public SingleSearchTerm(SingleOperation operation) {
        this(operation, 4);
    }

    public SingleSearchTerm(SingleOperation operation, int initialCapacity) {
        this.operation = operation;
        this.operands = new ArrayList(initialCapacity);
    }

    public Operand<?>[] getOperands() {
        return this.operands.toArray(new Operand[this.operands.size()]);
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public void addOperand(Operand<?> operand) {
        this.operands.add(operand);
    }

    public String toString() {
        return this.operation.getOperation() + ':' + this.operands;
    }

    public static enum SingleOperation implements Operation
    {
        EQUALS("=", 2, "=", SearchTerm.OperationPosition.BETWEEN, "%s=%s", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new EqualsTerm();
            }
        }),
        LESS_THAN("<", 2, "<", SearchTerm.OperationPosition.BETWEEN, "&(%1$s<=%2$s)(!(%1$s=%2$s))", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new LessThanTerm();
            }
        }),
        GREATER_THAN(">", 2, ">", SearchTerm.OperationPosition.BETWEEN, "&(%1$s>=%2$s)(!(%1$s=%2$s))", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new GreaterThanTerm();
            }
        }),
        NOT_EQUALS("<>", 2, "<>", SearchTerm.OperationPosition.BETWEEN, "!(%s=%s)", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new NotEqualTerm();
            }
        }),
        GREATER_OR_EQUAL(">=", 2, ">=", SearchTerm.OperationPosition.BETWEEN, "%s>=%s", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new GreaterOrEqualTerm();
            }
        }),
        LESS_OR_EQUAL("<=", 2, "<=", SearchTerm.OperationPosition.BETWEEN, "%s<=%s", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new LessOrEqualTerm();
            }
        }),
        ISNULL("isNull", 1, "IS NULL", SearchTerm.OperationPosition.AFTER, "!(%s=*)", new InstanceCreator(){

            @Override
            public SingleSearchTerm newInstance() {
                return new IsNullTerm();
            }
        });

        private final String str;
        private final String sql;
        private String ldap;
        private final InstanceCreator creator;
        private final int maxOperands;
        private SearchTerm.OperationPosition sqlPos;
        private SearchTerm.OperationPosition ldapPos;
        private static final transient Map<String, SingleOperation> map;

        private SingleOperation(String str, int maxOperands, String sql, SearchTerm.OperationPosition sqlPos, String ldap, InstanceCreator creator) {
            this.str = str;
            this.maxOperands = maxOperands;
            this.creator = creator;
            this.sql = sql;
            this.ldap = ldap;
            this.sqlPos = sqlPos;
        }

        @Override
        public String getOperation() {
            return this.str;
        }

        @Override
        public boolean equalsOperation(String other) {
            return this.str.equalsIgnoreCase(other);
        }

        public SingleSearchTerm newInstance() {
            return this.creator.newInstance();
        }

        public int getMaxOperands() {
            return this.maxOperands;
        }

        @Override
        public SearchTerm.OperationPosition getSqlPosition() {
            return this.sqlPos;
        }

        public static SingleOperation getSingleOperation(String operation) {
            SingleOperation[] values;
            SingleOperation retval = map.get(operation);
            if (null != retval) {
                return retval;
            }
            for (SingleOperation value : values = SingleOperation.values()) {
                if (!value.equalsOperation(operation)) continue;
                return value;
            }
            return null;
        }

        public static boolean containsOperation(String operation) {
            return null != SingleOperation.getSingleOperation(operation);
        }

        @Override
        public String getSqlRepresentation() {
            return this.sql;
        }

        @Override
        public String getLdapRepresentation() {
            return this.ldap;
        }

        public SearchTerm.OperationPosition getLdapPosition() {
            return this.ldapPos;
        }

        static {
            SingleOperation[] values = SingleOperation.values();
            HashMap<String, SingleOperation> m = new HashMap<String, SingleOperation>(values.length);
            for (SingleOperation singleOperation : values) {
                m.put(singleOperation.str, singleOperation);
            }
            map = Collections.unmodifiableMap(m);
        }
    }

    private static interface InstanceCreator
    extends Serializable {
        public SingleSearchTerm newInstance();
    }
}

