/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.internal.RdbResourceStorage;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ResourceStorageInit
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ResourceStorageInit.class));
    private static final ResourceStorageInit SINGLETON = new ResourceStorageInit();
    private static final AtomicBoolean initialized = new AtomicBoolean();

    public static ResourceStorageInit getInstance() {
        return SINGLETON;
    }

    private ResourceStorageInit() {
    }

    public void start() {
        if (!initialized.compareAndSet(false, true)) {
            LOG.warn((Object)"Duplicate resource storage start-up");
        }
        ResourceStorage.setInstance(new RdbResourceStorage());
        ServerServiceRegistry.getInstance().addService(ResourceService.class, ResourceServiceImpl.getInstance());
    }

    public void stop() {
        if (!initialized.compareAndSet(true, false)) {
            LOG.warn((Object)"Duplicate resource storage shut-down");
        }
        ServerServiceRegistry.getInstance().removeService(ResourceService.class);
        ResourceStorage.releaseInstance();
    }
}

