/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.LdapUtility;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceExceptionCode;
import com.openexchange.resource.ResourceGroup;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class RdbResourceStorage
extends ResourceStorage {
    private static final String RPL_TABLE = "#TABLE#";
    private static final String TABLE_ACTIVE = "resource";
    private static final String TABLE_DELETED = "del_resource";
    private static final String SQL_SELECT_GROUP = "SELECT id,identifier,displayName,available FROM resource_group WHERE cid = ?";
    private static final String SQL_SELECT_GROUP2 = "SELECT id,identifier,displayName,available FROM resource_group WHERE cid=? AND id IN #IDS#";
    private static final String SQL_SELECT_GROUP4 = "SELECT member FROM resource_group_member WHERE cid = ? AND id = ?";
    private static final String SQL_SELECT_RESOURCE3 = "SELECT id,identifier,displayName,mail,available,description,lastModified FROM resource WHERE cid = ? AND id IN #IDS#";
    private static final String SQL_SELECT_GROUP3 = "SELECT id,identifier,displayName,available FROM resource_group WHERE cid=? AND identifier LIKE ?";
    private static final String SQL_SELECT_RESOURCE2 = "SELECT id,identifier,displayName,mail,available,description,lastModified FROM resource WHERE cid = ? AND (identifier LIKE ? OR displayName LIKE ?)";
    private static final String SQL_SELECT_RESOURCE4 = "SELECT id,identifier,displayName,mail,available,description,lastModified FROM resource WHERE cid = ? AND mail LIKE ?";
    private static final String SQL_SELECT_RESOURCE = "SELECT id,identifier,displayName,mail,available,description,lastModified FROM resource WHERE cid = ? AND lastModified > ?";
    private static final String SQL_SELECT_DELETED_RESOURCE = "SELECT id,identifier,displayName,mail,available,description,lastModified FROM del_resource WHERE cid = ? AND lastModified > ?";
    private static final String SQL_INSERT_RESOURCE = "INSERT INTO #TABLE# (cid,id,identifier,displayName,mail,available,description,lastModified) VALUES (?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE_RESOURCE = "UPDATE resource SET identifier = ?, displayName = ?, mail = ?, available = ?, description = ?, lastModified = ? WHERE cid = ? AND id = ?";
    private static final String SQL_DELETE_RESOURCE = "DELETE FROM resource WHERE cid = ? AND id = ?";

    RdbResourceStorage() {
    }

    @Override
    public ResourceGroup getGroup(int groupId, Context context) throws OXException {
        ResourceGroup[] groups = this.getGroups(new int[]{groupId}, context);
        if (null == groups || groups.length == 0) {
            throw LdapExceptionCode.RESOURCEGROUP_NOT_FOUND.create(groupId).setPrefix("RES");
        }
        if (groups.length > 1) {
            throw LdapExceptionCode.RESOURCEGROUP_CONFLICT.create(groupId).setPrefix("RES");
        }
        return groups[0];
    }

    @Override
    public ResourceGroup[] getGroups(Context context) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        ArrayList<ResourceGroup> groups = new ArrayList<ResourceGroup>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_GROUP);
            stmt.setInt(1, context.getContextId());
            result = stmt.executeQuery();
            while (result.next()) {
                ResourceGroup group = new ResourceGroup();
                int pos = 1;
                group.setId(result.getInt(pos++));
                group.setIdentifier(result.getString(pos++));
                group.setDisplayName(result.getString(pos++));
                group.setAvailable(result.getBoolean(pos++));
                group.setMember(this.getMember(con, group.getId(), context));
                groups.add(group);
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return groups.toArray(new ResourceGroup[groups.size()]);
    }

    private ResourceGroup[] getGroups(int[] groupId, Context context) throws OXException {
        Connection con;
        if (null == groupId || groupId.length == 0) {
            return new ResourceGroup[0];
        }
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        StringBuilder ids = new StringBuilder(16);
        ids.append('(').append(groupId[0]);
        for (int i = 1; i < groupId.length; ++i) {
            ids.append(',').append(groupId[i]);
        }
        ids.append(')');
        ArrayList<ResourceGroup> groups = new ArrayList<ResourceGroup>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_GROUP2.replaceFirst("#IDS#", ids.toString()));
            stmt.setLong(1, context.getContextId());
            result = stmt.executeQuery();
            while (result.next()) {
                ResourceGroup group = new ResourceGroup();
                int pos = 1;
                group.setId(result.getInt(pos++));
                group.setIdentifier(result.getString(pos++));
                group.setDisplayName(result.getString(pos++));
                group.setAvailable(result.getBoolean(pos++));
                group.setMember(this.getMember(con, group.getId(), context));
                groups.add(group);
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return groups.toArray(new ResourceGroup[groups.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getMember(Connection con, int groupId, Context context) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<Integer> member = new ArrayList<Integer>();
        try {
            stmt = con.prepareStatement(SQL_SELECT_GROUP4);
            stmt.setLong(1, context.getContextId());
            stmt.setInt(2, groupId);
            result = stmt.executeQuery();
            while (result.next()) {
                member.add(result.getInt(1));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
        int[] retval = new int[member.size()];
        for (int i = 0; i < member.size(); ++i) {
            retval[i] = (Integer)member.get(i);
        }
        return retval;
    }

    @Override
    public Resource getResource(int resourceId, Context context) throws OXException {
        Resource[] resources = this.getResources(new int[]{resourceId}, context);
        if (resources.length == 0) {
            throw LdapExceptionCode.RESOURCE_NOT_FOUND.create(resourceId).setPrefix("RES");
        }
        if (resources.length > 1) {
            throw LdapExceptionCode.RESOURCE_CONFLICT.create(resourceId).setPrefix("RES");
        }
        return resources[0];
    }

    private Resource[] getResources(int[] resourceId, Context context) throws OXException {
        if (null == resourceId || resourceId.length == 0) {
            return new Resource[0];
        }
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        StringBuilder ids = new StringBuilder(16);
        ids.append('(').append(resourceId[0]);
        for (int i = 1; i < resourceId.length; ++i) {
            ids.append(',').append(resourceId[i]);
        }
        ids.append(')');
        ArrayList<Resource> resources = new ArrayList<Resource>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_RESOURCE3.replaceFirst("#IDS#", ids.toString()));
            stmt.setLong(1, context.getContextId());
            result = stmt.executeQuery();
            while (result.next()) {
                resources.add(this.createResourceFromEntry(result));
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public ResourceGroup[] searchGroups(String pattern, Context context) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        ArrayList<ResourceGroup> groups = new ArrayList<ResourceGroup>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_GROUP3);
            stmt.setLong(1, context.getContextId());
            stmt.setString(2, pattern.replace('*', '%'));
            result = stmt.executeQuery();
            while (result.next()) {
                ResourceGroup group = new ResourceGroup();
                int pos = 1;
                group.setId(result.getInt(pos++));
                group.setIdentifier(result.getString(pos++));
                group.setDisplayName(result.getString(pos++));
                group.setAvailable(result.getBoolean(pos++));
                group.setMember(this.getMember(con, group.getId(), context));
                groups.add(group);
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return groups.toArray(new ResourceGroup[groups.size()]);
    }

    @Override
    public Resource[] searchResources(String pattern, Context context) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_RESOURCE2);
            stmt.setLong(1, context.getContextId());
            stmt.setString(2, LdapUtility.prepareSearchPattern(pattern));
            stmt.setString(3, LdapUtility.prepareSearchPattern(pattern));
            result = stmt.executeQuery();
            while (result.next()) {
                resources.add(this.createResourceFromEntry(result));
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public Resource[] searchResourcesByMail(String pattern, Context context) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_RESOURCE4);
            stmt.setLong(1, context.getContextId());
            stmt.setString(2, LdapUtility.prepareSearchPattern(pattern));
            result = stmt.executeQuery();
            while (result.next()) {
                resources.add(this.createResourceFromEntry(result));
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public Resource[] listModified(Date modifiedSince, Context context) throws OXException {
        return this.listModifiedOrDeleted(modifiedSince, context, SQL_SELECT_RESOURCE);
    }

    @Override
    public Resource[] listDeleted(Date modifiedSince, Context context) throws OXException {
        return this.listModifiedOrDeleted(modifiedSince, context, SQL_SELECT_DELETED_RESOURCE);
    }

    private Resource[] listModifiedOrDeleted(Date modifiedSince, Context context, String statement) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("RES");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(statement);
            stmt.setLong(1, context.getContextId());
            stmt.setLong(2, modifiedSince.getTime());
            result = stmt.executeQuery();
            while (result.next()) {
                resources.add(this.createResourceFromEntry(result));
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("RES");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return resources.toArray(new Resource[resources.size()]);
    }

    private Resource createResourceFromEntry(ResultSet result) throws SQLException {
        Resource res = new Resource();
        int pos = 1;
        res.setIdentifier(result.getInt(pos++));
        res.setSimpleName(result.getString(pos++));
        res.setDisplayName(result.getString(pos++));
        String mail = result.getString(pos++);
        if (result.wasNull()) {
            res.setMail(null);
        } else {
            res.setMail(mail);
        }
        res.setAvailable(result.getBoolean(pos++));
        String desc = result.getString(pos++);
        if (result.wasNull()) {
            res.setDescription(null);
        } else {
            res.setDescription(desc);
        }
        res.setLastModified(result.getLong(pos++));
        return res;
    }

    @Override
    public void insertResource(Context ctx, Connection con, Resource resource, ResourceStorage.StorageType type) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_INSERT_RESOURCE.replaceFirst(RPL_TABLE, ResourceStorage.StorageType.ACTIVE.equals((Object)type) ? TABLE_ACTIVE : TABLE_DELETED));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, resource.getIdentifier());
            stmt.setString(pos++, resource.getSimpleName());
            stmt.setString(pos++, resource.getDisplayName());
            if (resource.getMail() == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, resource.getMail());
            }
            stmt.setBoolean(pos++, resource.isAvailable());
            if (resource.getDescription() == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, resource.getDescription());
            }
            long lastModified = System.currentTimeMillis();
            stmt.setLong(pos++, lastModified);
            stmt.executeUpdate();
            resource.setLastModified(lastModified);
        }
        catch (SQLException e) {
            try {
                throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    @Override
    public void updateResource(Context ctx, Connection con, Resource resource) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_UPDATE_RESOURCE);
            int pos = 1;
            stmt.setString(pos++, resource.getSimpleName());
            stmt.setString(pos++, resource.getDisplayName());
            if (resource.getMail() == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, resource.getMail());
            }
            stmt.setBoolean(pos++, resource.isAvailable());
            if (resource.getDescription() == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, resource.getDescription());
            }
            long lastModified = System.currentTimeMillis();
            stmt.setLong(pos++, lastModified);
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, resource.getIdentifier());
            stmt.executeUpdate();
            resource.setLastModified(lastModified);
        }
        catch (SQLException e) {
            throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    @Override
    public void deleteResourceById(Context ctx, Connection con, int resourceId) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_DELETE_RESOURCE);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, resourceId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }
}

