/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.request;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.json.writer.FolderWriter;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.parser.MailAccountParser;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.secret.SecretService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MailAccountRequest {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailAccountRequest.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final ServerSession session;
    private Date timestamp;
    private static final EnumSet<Attribute> DEFAULT = EnumSet.of(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL, new Attribute[]{Attribute.CONFIRMED_HAM_LITERAL, Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL, Attribute.CONFIRMED_SPAM_LITERAL, Attribute.DRAFTS_FULLNAME_LITERAL, Attribute.DRAFTS_LITERAL, Attribute.SENT_FULLNAME_LITERAL, Attribute.SENT_LITERAL, Attribute.SPAM_FULLNAME_LITERAL, Attribute.SPAM_LITERAL, Attribute.TRASH_FULLNAME_LITERAL, Attribute.TRASH_LITERAL});

    public Date getTimestamp() {
        return this.timestamp;
    }

    public MailAccountRequest(ServerSession session) {
        this.session = session;
    }

    public Object action(String action, JSONObject jsonObject) throws OXException, JSONException {
        if ("delete".equalsIgnoreCase(action)) {
            return this.actionDelete(jsonObject);
        }
        if ("new".equalsIgnoreCase(action)) {
            return this.actionNew(jsonObject);
        }
        if ("update".equalsIgnoreCase(action)) {
            return this.actionUpate(jsonObject);
        }
        if ("get".equalsIgnoreCase(action)) {
            return this.actionGet(jsonObject);
        }
        if ("all".equalsIgnoreCase(action)) {
            return this.actionAll(jsonObject);
        }
        if ("list".equalsIgnoreCase(action)) {
            return this.actionList(jsonObject);
        }
        if ("validate".equalsIgnoreCase(action)) {
            return this.actionValidate(jsonObject);
        }
        if ("get_tree".equalsIgnoreCase(action)) {
            return this.actionGetTree(jsonObject);
        }
        throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
    }

    private JSONObject actionGet(JSONObject jsonObject) throws JSONException, OXException, OXException, OXException {
        int id = DataParser.checkInt(jsonObject, "id");
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount mailAccount = storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId());
        if (MailAccountRequest.isUnifiedINBOXAccount(mailAccount)) {
            throw MailAccountExceptionCodes.NOT_FOUND.create(id, this.session.getUserId(), this.session.getContextId());
        }
        if (!this.session.getUserConfiguration().isMultipleMailAccounts() && !MailAccountRequest.isDefaultMailAccount(mailAccount)) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(this.session.getUserId(), this.session.getContextId());
        }
        JSONObject jsonAccount = MailAccountWriter.write(mailAccount);
        return jsonAccount;
    }

    private JSONObject actionGetTree(JSONObject jsonObject) throws JSONException, OXException, OXException, OXException {
        int id = DataParser.checkInt(jsonObject, "id");
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount mailAccount = storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId());
        if (MailAccountRequest.isUnifiedINBOXAccount(mailAccount)) {
            throw MailAccountExceptionCodes.NOT_FOUND.create(id, this.session.getUserId(), this.session.getContextId());
        }
        if (!this.session.getUserConfiguration().isMultipleMailAccounts() && !MailAccountRequest.isDefaultMailAccount(mailAccount)) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(this.session.getUserId(), this.session.getContextId());
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(this.session, mailAccount.getId());
        return this.actionValidateTree0(mailAccess);
    }

    private JSONArray actionDelete(JSONObject jsonObject) throws JSONException, OXException, OXException, OXException {
        int[] ids = DataParser.checkJSONIntArray(jsonObject, "data");
        JSONArray jsonArray = new JSONArray();
        if (!this.session.getUserConfiguration().isMultipleMailAccounts()) {
            for (int id : ids) {
                if (0 == id) continue;
                throw MailAccountExceptionCodes.NOT_ENABLED.create(this.session.getUserId(), this.session.getContextId());
            }
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        for (int id : ids) {
            MailAccount mailAccount = storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId());
            if (!MailAccountRequest.isUnifiedINBOXAccount(mailAccount)) {
                storageService.deleteMailAccount(id, Collections.<String, Object>emptyMap(), this.session.getUserId(), this.session.getContextId());
            }
            jsonArray.put(id);
        }
        return jsonArray;
    }

    private JSONObject actionNew(JSONObject jsonObject) throws OXException, OXException, JSONException {
        JSONObject jData = DataParser.checkJSONObject(jsonObject, "data");
        if (!this.session.getUserConfiguration().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(this.session.getUserId(), this.session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        MailAccountParser.getInstance().parse(accountDescription, jData);
        MailAccountRequest.checkNeededFields(accountDescription);
        if (MailAccountRequest.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.CREATION_FAILED.create();
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        int id = storageService.insertMailAccount(accountDescription, this.session.getUserId(), this.session.getContext(), this.session);
        JSONObject jsonAccount = MailAccountWriter.write(storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId()));
        return jsonAccount;
    }

    private String getSecret(ServerSession session) {
        SecretService secretService = ServerServiceRegistry.getInstance().getService(SecretService.class);
        return secretService.getSecret((Session)session);
    }

    private Object actionValidate(JSONObject jsonObject) throws OXException, OXException, JSONException {
        boolean tree;
        JSONObject jData = DataParser.checkJSONObject(jsonObject, "data");
        if (!this.session.getUserConfiguration().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(this.session.getUserId(), this.session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        MailAccountParser.getInstance().parse(accountDescription, jData);
        if (accountDescription.getId() >= 0 && null == accountDescription.getPassword()) {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            String password = storageService.getMailAccount(accountDescription.getId(), this.session.getUserId(), this.session.getContextId()).getPassword();
            accountDescription.setPassword(MailPasswordUtil.decrypt(password, this.session, accountDescription.getId(), accountDescription.getLogin(), accountDescription.getMailServer()));
        }
        MailAccountRequest.checkNeededFields(accountDescription);
        if (MailAccountRequest.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.VALIDATION_FAILED.create();
        }
        boolean bl = tree = jsonObject.hasAndNotNull("tree") ? jsonObject.getBoolean("tree") : false;
        if (tree) {
            return this.actionValidateTree(accountDescription);
        }
        return this.actionValidateBoolean(accountDescription);
    }

    private JSONObject actionValidateTree(MailAccountDescription accountDescription) throws OXException, OXException, JSONException, OXException {
        if (!this.actionValidateBoolean(accountDescription).booleanValue()) {
            return null;
        }
        MailAccess<?, ?> mailAccess = this.getMailAccess(accountDescription);
        return this.actionValidateTree0(mailAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject actionValidateTree0(MailAccess<?, ?> mailAccess) throws JSONException {
        boolean close = false;
        try {
            mailAccess.connect();
            close = true;
            JSONObject root = FolderWriter.writeMailFolder(-1, mailAccess.getRootFolder(), mailAccess.getMailConfig(), this.session);
            this.addSubfolders(root, mailAccess.getFolderStorage().getSubfolders("default", true), mailAccess, mailAccess.getMailConfig());
            JSONObject jSONObject = root;
            return jSONObject;
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Composing mail account's folder tree failed.", (Throwable)e);
            }
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (close) {
                mailAccess.close(false);
            }
        }
    }

    private void addSubfolders(JSONObject parent, MailFolder[] subfolders, MailAccess<?, ?> mailAccess, MailConfig mailConfig) throws JSONException, OXException {
        if (subfolders.length == 0) {
            return;
        }
        JSONArray subfolderArray = new JSONArray();
        parent.put("subfolder_array", (Object)subfolderArray);
        for (MailFolder subfolder : subfolders) {
            JSONObject subfolderObject = FolderWriter.writeMailFolder(-1, subfolder, mailConfig, this.session);
            subfolderArray.put((Object)subfolderObject);
            this.addSubfolders(subfolderObject, mailAccess.getFolderStorage().getSubfolders(subfolder.getFullname(), true), mailAccess, mailConfig);
        }
    }

    private Boolean actionValidateBoolean(MailAccountDescription accountDescription) throws OXException {
        boolean validated = this.checkMailServerURL(accountDescription);
        if (!validated) {
            return Boolean.FALSE;
        }
        String transportServer = accountDescription.getTransportServer();
        if (null != transportServer && transportServer.length() > 0) {
            validated = this.checkTransportServerURL(accountDescription);
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailAccess<?, ?> getMailAccess(MailAccountDescription accountDescription) throws OXException, OXException {
        String mailServerURL = accountDescription.generateMailServerURL();
        MailProvider mailProvider = MailProviderRegistry.getMailProviderByURL(mailServerURL);
        if (null == mailProvider) {
            if (DEBUG) {
                LOG.debug((Object)("Validating mail account failed. No mail provider found for URL: " + mailServerURL));
            }
            return null;
        }
        this.session.setParameter("mail-account.request", "validate");
        try {
            MailAccess<?, ?> mailAccess = mailProvider.createNewMailAccess(this.session);
            MailConfig mailConfig = mailAccess.getMailConfig();
            mailConfig.setLogin(accountDescription.getLogin());
            mailConfig.setPassword(accountDescription.getPassword());
            String[] tmp = MailConfig.parseProtocol(mailServerURL);
            String server = tmp == null ? mailServerURL : tmp[1];
            int pos = server.indexOf(58);
            if (pos == -1) {
                mailConfig.setPort(143);
                mailConfig.setServer(server);
            } else {
                String sPort = server.substring(pos + 1);
                try {
                    mailConfig.setPort(Integer.parseInt(sPort));
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)new StringAllocator().append("Cannot parse port out of string: \"").append(sPort).append("\". Using fallback 143 instead."), (Throwable)e);
                    mailConfig.setPort(143);
                }
                mailConfig.setServer(server.substring(0, pos));
            }
            mailConfig.setSecure(accountDescription.isMailSecure());
            mailAccess.setCacheable(false);
            MailAccess<?, ?> mailAccess2 = mailAccess;
            return mailAccess2;
        }
        finally {
            this.session.setParameter("mail-account.request", null);
        }
    }

    private boolean checkMailServerURL(MailAccountDescription accountDescription) throws OXException, OXException {
        MailAccess<?, ?> mailAccess = this.getMailAccess(accountDescription);
        if (null == mailAccess) {
            return false;
        }
        return mailAccess.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTransportServerURL(MailAccountDescription accountDescription) throws OXException, OXException {
        String transportServerURL = accountDescription.generateTransportServerURL();
        TransportProvider transportProvider = TransportProviderRegistry.getTransportProviderByURL(transportServerURL);
        if (null == transportProvider) {
            if (DEBUG) {
                LOG.debug((Object)("Validating mail account failed. No transport provider found for URL: " + transportServerURL));
            }
            return false;
        }
        MailTransport mailTransport = transportProvider.createNewMailTransport(this.session);
        TransportConfig transportConfig = mailTransport.getTransportConfig();
        String login = accountDescription.getTransportLogin();
        if (null == login) {
            login = accountDescription.getLogin();
        }
        transportConfig.setLogin(login);
        String password = accountDescription.getTransportPassword();
        if (null == password) {
            password = accountDescription.getPassword();
        }
        transportConfig.setPassword(password);
        String[] tmp = MailConfig.parseProtocol(transportServerURL);
        String server = tmp == null ? transportServerURL : tmp[1];
        int pos = server.indexOf(58);
        if (pos == -1) {
            transportConfig.setPort(25);
            transportConfig.setServer(server);
        } else {
            String sPort = server.substring(pos + 1);
            try {
                transportConfig.setPort(Integer.parseInt(sPort));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)new StringAllocator().append("Cannot parse port out of string: \"").append(sPort).append("\". Using fallback 25 instead."), (Throwable)e);
                transportConfig.setPort(25);
            }
            transportConfig.setServer(server.substring(0, pos));
        }
        transportConfig.setSecure(accountDescription.isTransportSecure());
        boolean validated = true;
        boolean close = false;
        try {
            mailTransport.ping();
            close = true;
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Validating transport account failed.", (Throwable)e);
            }
            validated = false;
        }
        finally {
            if (close) {
                mailTransport.close();
            }
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject actionUpate(JSONObject jsonObject) throws OXException, OXException, JSONException {
        JSONObject jData = DataParser.checkJSONObject(jsonObject, "data");
        MailAccountDescription accountDescription = new MailAccountDescription();
        Set<Attribute> fieldsToUpdate = MailAccountParser.getInstance().parse(accountDescription, jData);
        if (!this.session.getUserConfiguration().isMultipleMailAccounts() && !MailAccountRequest.isDefaultMailAccount(accountDescription)) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(this.session.getUserId(), this.session.getContextId());
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        int id = accountDescription.getId();
        if (-1 == id) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
        }
        MailAccount toUpdate = storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId());
        if (MailAccountRequest.isUnifiedINBOXAccount(toUpdate)) {
            throw MailAccountExceptionCodes.NOT_FOUND.create(id, this.session.getUserId(), this.session.getContextId());
        }
        storageService.updateMailAccount(accountDescription, fieldsToUpdate, this.session.getUserId(), this.session.getContextId(), this.session);
        if (fieldsToUpdate.removeAll(DEFAULT)) {
            MailSessionCache.getInstance(this.session).removeAccountParameters(id);
            try {
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                try {
                    mailAccess = MailAccess.getInstance(this.session, id);
                    mailAccess.connect(false);
                    mailAccess.getFolderStorage().checkDefaultFolders();
                }
                finally {
                    if (null != mailAccess) {
                        mailAccess.close(true);
                    }
                }
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        JSONObject jsonAccount = MailAccountWriter.write(storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId()));
        return jsonAccount;
    }

    private JSONArray actionAll(JSONObject request) throws OXException {
        String colString = request.optString("columns");
        List<Attribute> attributes = this.getColumns(colString);
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount[] userMailAccounts = storageService.getUserMailAccounts(this.session.getUserId(), this.session.getContextId());
        boolean multipleEnabled = this.session.getUserConfiguration().isMultipleMailAccounts();
        ArrayList<MailAccount> tmp = new ArrayList<MailAccount>(userMailAccounts.length);
        for (MailAccount userMailAccount : userMailAccounts) {
            MailAccount mailAccount = userMailAccount;
            if (MailAccountRequest.isUnifiedINBOXAccount(mailAccount) || !multipleEnabled && !MailAccountRequest.isDefaultMailAccount(mailAccount)) continue;
            tmp.add(mailAccount);
        }
        userMailAccounts = tmp.toArray(new MailAccount[tmp.size()]);
        return MailAccountWriter.writeArray(userMailAccounts, attributes, this.session);
    }

    private List<Attribute> getColumns(String colString) {
        LinkedList<Attribute> attributes = null;
        if (colString != null && !"".equals(colString.trim())) {
            attributes = new LinkedList<Attribute>();
            for (String col : colString.split("\\s*,\\s*")) {
                if ("".equals(col)) continue;
                attributes.add(Attribute.getById(Integer.parseInt(col)));
            }
            return attributes;
        }
        return Arrays.asList(Attribute.values());
    }

    private JSONArray actionList(JSONObject request) throws JSONException, OXException {
        String colString = request.optString("columns");
        List<Attribute> attributes = this.getColumns(colString);
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        JSONArray ids = request.getJSONArray("data");
        boolean multipleEnabled = this.session.getUserConfiguration().isMultipleMailAccounts();
        ArrayList<MailAccount> accounts = new ArrayList<MailAccount>();
        int size = ids.length();
        for (int i = 0; i < size; ++i) {
            int id = ids.getInt(i);
            MailAccount account = storageService.getMailAccount(id, this.session.getUserId(), this.session.getContextId());
            if (MailAccountRequest.isUnifiedINBOXAccount(account) || !multipleEnabled && !MailAccountRequest.isDefaultMailAccount(account)) continue;
            accounts.add(account);
        }
        return MailAccountWriter.writeArray(accounts.toArray(new MailAccount[accounts.size()]), attributes, this.session);
    }

    private static boolean isUnifiedINBOXAccount(MailAccount mailAccount) {
        return MailAccountRequest.isUnifiedINBOXAccount(mailAccount.getMailProtocol());
    }

    private static boolean isUnifiedINBOXAccount(String mailProtocol) {
        return "unifiedinbox".equals(mailProtocol);
    }

    private static boolean isDefaultMailAccount(MailAccount mailAccount) {
        return mailAccount.isDefaultAccount() || 0 == mailAccount.getId();
    }

    private static boolean isDefaultMailAccount(MailAccountDescription mailAccount) {
        return 0 == mailAccount.getId();
    }

    private static void checkNeededFields(MailAccountDescription accountDescription) throws OXException {
        if (null == accountDescription.getMailServer()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("mail_url");
        }
        if (null == accountDescription.getLogin()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("login");
        }
        if (null == accountDescription.getPassword()) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
    }
}

