/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.databaseold.Database;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.actions.ValidateAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.parser.MailAccountParser;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.PUT, name="new", description="Create a new mail account", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="A JSON object describing the new account to create. See mail account data.", responseDescription="A JSON object representing the inserted mail account. See mail account data.")
public final class NewAction
extends AbstractMailAccountAction
implements MailAccountFields {
    public static final String ACTION = "new";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        JSONObject jBody;
        int id;
        if (!session.getUserConfiguration().isMultipleMailAccounts()) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
        }
        MailAccountDescription accountDescription = new MailAccountDescription();
        MailAccountParser.getInstance().parse(accountDescription, jData.toObject());
        NewAction.checkNeededFields(accountDescription);
        if (NewAction.isUnifiedINBOXAccount(accountDescription.getMailProtocol())) {
            throw MailAccountExceptionCodes.CREATION_FAILED.create();
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        boolean pop3 = accountDescription.getMailProtocol().toLowerCase(Locale.ENGLISH).startsWith("pop3");
        if (!pop3) {
            session.setParameter("mail-account.validate.type", "create");
            try {
                if (!ValidateAction.actionValidateBoolean(accountDescription, session, warnings).booleanValue()) {
                    OXException warning = MimeMailExceptionCode.CONNECT_ERROR.create(accountDescription.getMailServer(), accountDescription.getLogin());
                    warning.setCategory(Category.CATEGORY_WARNING);
                    warnings.add(0, warning);
                }
            }
            finally {
                session.setParameter("mail-account.validate.type", null);
            }
        }
        int cid = session.getContextId();
        Connection con = null;
        con = Database.get(cid, true);
        MailAccount newAccount = null;
        try {
            MailAccount[] accounts;
            con.setAutoCommit(false);
            id = storageService.insertMailAccount(accountDescription, session.getUserId(), session.getContext(), session, con);
            for (MailAccount mailAccount : accounts = storageService.getUserMailAccounts(session.getUserId(), cid, con)) {
                if (mailAccount.getId() != id) continue;
                newAccount = mailAccount;
                break;
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(cid, true, con);
        }
        if (null != newAccount) {
            NewAction.checkFullNames(newAccount, storageService, session, null);
        }
        if ((jBody = jData.toObject()).hasAndNotNull("meta")) {
            JSONObject jMeta = jBody.optJSONObject("meta");
            NewAction.getStorage().store(new JSlobId("com.openexchange.mailaccount", Integer.toString(id), session.getUserId(), session.getContextId()), (JSlob)new DefaultJSlob(jMeta));
        }
        JSONObject jsonAccount = MailAccountWriter.write(NewAction.checkFullNames(storageService.getMailAccount(id, session.getUserId(), session.getContextId()), storageService, session));
        return new AJAXRequestResult(jsonAccount).addWarnings(warnings);
    }
}

