/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search.service;

import com.openexchange.mail.search.ANDTerm;
import com.openexchange.mail.search.BooleanTerm;
import com.openexchange.mail.search.NOTTerm;
import com.openexchange.mail.search.ORTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.service.MailAttributeFetcher;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.Operand;
import com.openexchange.search.Operation;
import com.openexchange.search.SingleSearchTerm;
import java.text.MessageFormat;
import java.util.Arrays;

public final class SearchTermMapper {
    private SearchTermMapper() {
    }

    public static SearchTerm<?> map(com.openexchange.search.SearchTerm<?> searchTerm) {
        Operation operation = searchTerm.getOperation();
        if (CompositeSearchTerm.CompositeOperation.AND.equals(operation)) {
            ANDTerm andTerm;
            com.openexchange.search.SearchTerm<?>[] searchTerms = ((CompositeSearchTerm)searchTerm).getOperands();
            int length = searchTerms.length;
            if (length == 0) {
                return BooleanTerm.TRUE;
            }
            if (1 == length) {
                andTerm = new ANDTerm(SearchTermMapper.map(searchTerms[0]), BooleanTerm.TRUE);
            } else {
                andTerm = new ANDTerm(SearchTermMapper.map(searchTerms[0]), SearchTermMapper.map(searchTerms[1]));
                for (int i = 2; i < length; ++i) {
                    andTerm = new ANDTerm(andTerm, SearchTermMapper.map(searchTerms[i]));
                }
            }
            return andTerm;
        }
        if (CompositeSearchTerm.CompositeOperation.OR.equals(operation)) {
            ORTerm orTerm;
            com.openexchange.search.SearchTerm<?>[] searchTerms = ((CompositeSearchTerm)searchTerm).getOperands();
            int length = searchTerms.length;
            if (length == 0) {
                return BooleanTerm.TRUE;
            }
            if (1 == length) {
                orTerm = new ORTerm(SearchTermMapper.map(searchTerms[0]), BooleanTerm.FALSE);
            } else {
                orTerm = new ORTerm(SearchTermMapper.map(searchTerms[0]), SearchTermMapper.map(searchTerms[1]));
                for (int i = 2; i < length; ++i) {
                    orTerm = new ORTerm(orTerm, SearchTermMapper.map(searchTerms[i]));
                }
            }
            return orTerm;
        }
        if (CompositeSearchTerm.CompositeOperation.NOT.equals(operation)) {
            com.openexchange.search.SearchTerm<?>[] searchTerms = ((CompositeSearchTerm)searchTerm).getOperands();
            int length = searchTerms.length;
            if (length == 0) {
                return BooleanTerm.TRUE;
            }
            return new NOTTerm(SearchTermMapper.map(searchTerms[0]));
        }
        Object[] values = SearchTermMapper.getNameAndConstant((Operand[])searchTerm.getOperands());
        if (null == values) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid values for single search term: {0}", Arrays.toString(searchTerm.getOperands())));
        }
        SearchTerm<?> term = MailAttributeFetcher.getInstance().getSearchTerm(values[0].toString(), SearchTermMapper.getSingleOperation(operation), values[1]);
        return null == term ? BooleanTerm.TRUE : term;
    }

    private static SingleSearchTerm.SingleOperation getSingleOperation(Operation operation) {
        if (SingleSearchTerm.SingleOperation.EQUALS.equals(operation)) {
            return SingleSearchTerm.SingleOperation.EQUALS;
        }
        if (SingleSearchTerm.SingleOperation.GREATER_THAN.equals(operation)) {
            return SingleSearchTerm.SingleOperation.GREATER_THAN;
        }
        if (SingleSearchTerm.SingleOperation.LESS_THAN.equals(operation)) {
            return SingleSearchTerm.SingleOperation.LESS_THAN;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unknown single search term operation: {0}", operation));
    }

    private static Object[] getNameAndConstant(Operand[] operands) {
        if (Operand.Type.CONSTANT.equals((Object)operands[0].getType())) {
            return new Object[]{operands[1].getValue().toString(), operands[0].getValue()};
        }
        if (Operand.Type.CONSTANT.equals((Object)operands[1].getType())) {
            return new Object[]{operands[0].getValue().toString(), operands[1].getValue()};
        }
        return null;
    }
}

