/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.mail.mime.utils.MimeMessageUtility;
import java.util.Locale;
import javax.mail.internet.InternetAddress;

public final class PlainTextAddress
extends InternetAddress {
    private static final long serialVersionUID = -3276144799717449603L;
    private static final String TYPE = "rfc822";
    private final String address;
    private final int hashCode;

    public static PlainTextAddress[] getAddresses(String[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return new PlainTextAddress[0];
        }
        PlainTextAddress[] retval = new PlainTextAddress[addresses.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = new PlainTextAddress(addresses[i]);
        }
        return retval;
    }

    public PlainTextAddress(String address) {
        this.address = MimeMessageUtility.decodeMultiEncodedHeader(address);
        this.hashCode = address.toLowerCase(Locale.ENGLISH).hashCode();
    }

    public String getType() {
        return TYPE;
    }

    public String toString() {
        return this.address;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        return null;
    }

    public boolean equals(Object address) {
        if (address instanceof InternetAddress) {
            InternetAddress ia = (InternetAddress)address;
            return this.address.equalsIgnoreCase(ia.getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toUnicodeString() {
        return MimeMessageUtility.decodeMultiEncodedHeader(this.address);
    }
}

