/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeTypeFileLineParser;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;

public final class MimeType2ExtMap {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeType2ExtMap.class));
    private static volatile Map<String, String> typeMap;
    private static volatile Map<String, List<String>> extMap;
    private static final List<String> DEFAULT_EXT;

    private MimeType2ExtMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reset() {
        if (null == typeMap) return;
        Class<MimeType2ExtMap> clazz = MimeType2ExtMap.class;
        synchronized (MimeType2ExtMap.class) {
            if (null == typeMap) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            typeMap = null;
            extMap = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (null != typeMap) return;
        Class<MimeType2ExtMap> clazz = MimeType2ExtMap.class;
        synchronized (MimeType2ExtMap.class) {
            if (null != typeMap) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                ConfigurationService service;
                File file;
                URL url;
                String javaHome;
                File file2;
                typeMap = new HashMap<String, String>();
                extMap = new HashMap<String, List<String>>();
                StringBuilder sb = new StringBuilder(128);
                boolean debugEnabled = LOG.isDebugEnabled();
                String homeDir = System.getProperty("user.home");
                if (homeDir != null && (file2 = new File(sb.append(homeDir).append(File.separatorChar).append(".mime.types").toString())).exists()) {
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug((Object)sb.append("Loading MIME type file \"").append(file2.getPath()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(file2);
                }
                if ((javaHome = System.getProperty("java.home")) != null) {
                    sb.setLength(0);
                    file2 = new File(sb.append(javaHome).append(File.separatorChar).append("lib").append(File.separator).append("mime.types").toString());
                    if (file2.exists()) {
                        if (debugEnabled) {
                            sb.setLength(0);
                            LOG.debug((Object)sb.append("Loading MIME type file \"").append(file2.getPath()).append('\"').toString());
                        }
                        MimeType2ExtMap.loadInternal(file2);
                    }
                }
                Enumeration<URL> e = ClassLoader.getSystemResources("META-INF/mime.types");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug((Object)sb.append("Loading MIME type file \"").append(url.getFile()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(url);
                }
                e = ClassLoader.getSystemResources("META-INF/mimetypes.default");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug((Object)sb.append("Loading MIME type file \"").append(url.getFile()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(url);
                }
                String mimeTypesFileName = SystemConfig.getProperty(SystemConfig.Property.MimeTypeFileName);
                if (mimeTypesFileName != null && (mimeTypesFileName = mimeTypesFileName.trim()).length() > 0 && (file = (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)).getFileByName(mimeTypesFileName)).exists()) {
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug((Object)sb.append("Loading MIME type file \"").append(file.getPath()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(file);
                }
                if (!LOG.isDebugEnabled()) return;
                LOG.debug((Object)"MIMEType2ExtMap successfully initialized");
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
    }

    public static String getContentType(File file) {
        return MimeType2ExtMap.getContentType(file.getName());
    }

    public static String getContentType(String fileName) {
        MimeType2ExtMap.init();
        if (null == fileName) {
            return "application/octet-stream";
        }
        int pos = fileName.lastIndexOf(46);
        if (pos < 0) {
            return "application/octet-stream";
        }
        String s1 = fileName.substring(pos + 1);
        if (s1.length() == 0) {
            return "application/octet-stream";
        }
        String type = typeMap.get(s1.toLowerCase(Locale.ENGLISH));
        if (null == type) {
            return "application/octet-stream";
        }
        return type;
    }

    public static String getContentTypeByExtension(String extension) {
        MimeType2ExtMap.init();
        if (null == extension || 0 == extension.length()) {
            return "application/octet-stream";
        }
        String type = typeMap.get(extension.toLowerCase(Locale.ENGLISH));
        if (null == type) {
            return "application/octet-stream";
        }
        return type;
    }

    public static List<String> getFileExtensions(String mimeType) {
        MimeType2ExtMap.init();
        return extMap.containsKey(mimeType.toLowerCase(Locale.ENGLISH)) ? Collections.unmodifiableList(extMap.get(mimeType)) : DEFAULT_EXT;
    }

    public static void load(String fileStr) {
        MimeType2ExtMap.init();
        MimeType2ExtMap.load(new File(fileStr));
    }

    public static void load(File file) {
        MimeType2ExtMap.init();
        MimeType2ExtMap.loadInternal(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.ISO_8859_1));
            MimeType2ExtMap.parse(reader);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(URL url) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.ISO_8859_1));
            MimeType2ExtMap.parse(reader);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void parse(BufferedReader reader) throws IOException {
        String line = null;
        StringBuilder strBuilder = new StringBuilder(64);
        while ((line = reader.readLine()) != null) {
            int i = strBuilder.length();
            strBuilder.append(line);
            if (i > 0 && strBuilder.charAt(i - 1) == '\\') {
                strBuilder.delete(0, i - 1);
                continue;
            }
            MimeType2ExtMap.parseEntry(strBuilder.toString().trim());
            strBuilder.setLength(0);
        }
        if (strBuilder.length() > 0) {
            MimeType2ExtMap.parseEntry(strBuilder.toString().trim());
        }
    }

    private static void parseEntry(String entry) {
        if (entry.length() == 0) {
            return;
        }
        if (entry.charAt(0) == '#') {
            return;
        }
        Map<String, List<String>> extMap = MimeType2ExtMap.extMap;
        Map<String, String> typeMap = MimeType2ExtMap.typeMap;
        if (entry.indexOf(61) > 0) {
            MimeTypeFileLineParser parser = new MimeTypeFileLineParser(entry);
            String type = parser.getType();
            List<String> exts = parser.getExtensions();
            if (type != null && exts != null) {
                for (String ext : exts) {
                    typeMap.put(ext, type);
                }
                if (extMap.containsKey(type)) {
                    extMap.get(type).addAll(exts);
                } else {
                    extMap.put(type, exts);
                }
            }
        } else {
            String[] tokens = entry.split("[ \t\n\r\f]+");
            if (tokens.length > 1) {
                String type = tokens[0].toLowerCase(Locale.ENGLISH);
                ArrayList<String> set = new ArrayList<String>();
                for (int i = 1; i < tokens.length; ++i) {
                    String ext = tokens[i].toLowerCase(Locale.ENGLISH);
                    set.add(ext);
                    typeMap.put(ext, type);
                }
                if (extMap.containsKey(type)) {
                    extMap.get(type).addAll(set);
                } else {
                    extMap.put(type, set);
                }
            }
        }
    }

    static {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add("dat");
        DEFAULT_EXT = Collections.unmodifiableList(l);
    }
}

