/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionMessage;

public enum MimeMailExceptionCode implements OXExceptionCode
{
    LOGIN_FAILED("There was an issue in authenticating your E-Mail password. This may be due to a recent password change. To continue please log out now and then log back in with your most current password. (server=%1$s | user=%2$s)", CATEGORY_PERMISSION_DENIED, 1000),
    INVALID_CREDENTIALS("Wrong or missing login data to access mail server %1$s. Error message from mail server: %2$s", CATEGORY_PERMISSION_DENIED, 1001),
    INVALID_CREDENTIALS_EXT("Wrong or missing login data to access mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail server: %5$s", CATEGORY_PERMISSION_DENIED, MimeMailExceptionCode.INVALID_CREDENTIALS.detailNumber),
    FOLDER_NOT_FOUND("Mail folder \"%1$s\" could not be found.", CATEGORY_ERROR, 1002),
    FOLDER_NOT_FOUND_EXT("Mail folder \"%1$s\" could not be found on mail server %2$s with login %3$s (user=%4$s, context=%5$s).", CATEGORY_ERROR, MimeMailExceptionCode.FOLDER_NOT_FOUND.detailNumber),
    FOLDER_CLOSED(MimeMailExceptionMessage.FOLDER_CLOSED_MSG, CATEGORY_ERROR, 1003),
    FOLDER_CLOSED_EXT(MimeMailExceptionMessage.FOLDER_CLOSED_EXT_MSG, CATEGORY_ERROR, MimeMailExceptionCode.FOLDER_CLOSED.detailNumber),
    ILLEGAL_WRITE("Illegal write attempt: %1$s", CATEGORY_ERROR, 1004),
    MESSAGE_REMOVED(MimeMailExceptionMessage.MESSAGE_REMOVED, MailExceptionCode.MAIL_NOT_FOUND.getCategory(), MailExceptionCode.MAIL_NOT_FOUND.getNumber()),
    METHOD_NOT_SUPPORTED("Method not supported: %1$s", CATEGORY_ERROR, 1006),
    NO_SUCH_PROVIDER("Session attempts to instantiate a provider that does not exist: %1$s", CATEGORY_ERROR, 1007),
    INVALID_EMAIL_ADDRESS("Invalid E-Mail address %1$s", CATEGORY_USER_INPUT, 1008),
    PARSE_ERROR("Wrong message header: %1$s", CATEGORY_USER_INPUT, 1009),
    READ_ONLY_FOLDER("An attempt was made to open a read-only folder with read-write \"%1$s\"", CATEGORY_PERMISSION_DENIED, 1010),
    READ_ONLY_FOLDER_EXT("An attempt was made to open a read-only folder with read-write \"%1$s\" on mail server %2$s with login %3$s (user=%4$s, context=%5$s)", CATEGORY_PERMISSION_DENIED, 1010),
    SEARCH_ERROR("Invalid search expression: %1$s", CATEGORY_USER_INPUT, 1011),
    MESSAGE_TOO_LARGE("Message could not be sent because it is too large", CATEGORY_USER_INPUT, 1012),
    SEND_FAILED("Message could not be sent to the following recipients: %1$s", CATEGORY_USER_INPUT, 1013),
    SEND_FAILED_EXT("Message could not be sent to the following recipients: %1$s %2$s", CATEGORY_USER_INPUT, 1013),
    STORE_CLOSED("Lost connection to mail server.", CATEGORY_SERVICE_DOWN, 1014),
    STORE_CLOSED_EXT("Connection closed to mail server %1$s with login %2$s (user=%3$s, context=%4$s).", MimeMailExceptionCode.STORE_CLOSED.category, MimeMailExceptionCode.STORE_CLOSED.detailNumber),
    BIND_ERROR("Could not bind connection to local port %1$s", CATEGORY_CONFIGURATION, 1015),
    CONNECT_ERROR("Connection was refused or timed out while attempting to connect to remote server %1$s for user %2$s.", CATEGORY_SERVICE_DOWN, 1016),
    CONNECTION_RESET("Connection was reset. Please try again.", CATEGORY_TRY_AGAIN, 1017),
    NO_ROUTE_TO_HOST("No route to host: server (%1$s) cannot be reached", CATEGORY_SERVICE_DOWN, 1018),
    PORT_UNREACHABLE("Port %1$s was unreachable on remote server", CATEGORY_SERVICE_DOWN, 1019),
    BROKEN_CONNECTION("Connection is broken due to a socket exception on remote server: %1$s", CATEGORY_SERVICE_DOWN, 1020),
    SOCKET_ERROR("A socket error occurred: %1$s", CATEGORY_ERROR, 1021),
    UNKNOWN_HOST("The IP address of host \"%1$s\" could not be determined", CATEGORY_SERVICE_DOWN, 1022),
    MESSAGING_ERROR("Messaging error: %1$s", CATEGORY_ERROR, 1023),
    QUOTA_EXCEEDED("The quota on mail server exceeded.", CATEGORY_CAPACITY, 1024),
    QUOTA_EXCEEDED_EXT("The quota on mail server \"%1$s\" exceeded with login %2$s (user=%3$s, context=%4$s).", MimeMailExceptionCode.QUOTA_EXCEEDED.category, MimeMailExceptionCode.QUOTA_EXCEEDED.detailNumber),
    COMMAND_FAILED("A command to mail server failed. Server response: %1$s.", CATEGORY_ERROR, 1025),
    COMMAND_FAILED_EXT("A command failed on mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s", MimeMailExceptionCode.COMMAND_FAILED.category, MimeMailExceptionCode.COMMAND_FAILED.detailNumber),
    BAD_COMMAND("Mail server indicates a bad command. Server response: %1$s", CATEGORY_ERROR, 1026),
    BAD_COMMAND_EXT("Bad command indicated by mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s", MimeMailExceptionCode.BAD_COMMAND.category, MimeMailExceptionCode.BAD_COMMAND.detailNumber),
    PROTOCOL_ERROR("Error in mail server protocol. Error message: %1$s", CATEGORY_ERROR, 1027),
    PROTOCOL_ERROR_EXT("Error in protocol to mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message: %5$s", MimeMailExceptionCode.PROTOCOL_ERROR.category, MimeMailExceptionCode.PROTOCOL_ERROR.detailNumber),
    SEND_FAILED_MSG("Message could not be sent to the following recipients: %1$s", CATEGORY_USER_INPUT, 1028),
    SEND_FAILED_MSG_EXT("Message could not be sent to the following recipients: %1$s %2$s", CATEGORY_USER_INPUT, 1028),
    MESSAGE_NOT_DISPLAYED("Message cannot be displayed.", CATEGORY_USER_INPUT, 1029),
    TRANSPORT_INVALID_CREDENTIALS("Wrong or missing login data to access mail transport server %1$s. Error message from mail transport server: %2$s", CATEGORY_PERMISSION_DENIED, 1030),
    TRANSPORT_INVALID_CREDENTIALS_EXT("Wrong or missing login data to access mail transport server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail transport server: %5$s", CATEGORY_PERMISSION_DENIED, MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.detailNumber),
    PROCESSING_ERROR("Error processing mail server response. The administrator has been informed.", CATEGORY_ERROR, 1031),
    PROCESSING_ERROR_EXT("Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed.", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber),
    IO_ERROR(MailExceptionCode.IO_ERROR),
    IO_ERROR_EXT(MailExceptionCode.IO_ERROR, "I/O error \"%1$s\" occurred in communication with \"%2$s\" mail server for login %3$s (user=%4$s, context=%5$s)."),
    PROCESSING_ERROR_WE("Error processing mail server response. The administrator has been informed. Error message: %1$s", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber),
    PROCESSING_ERROR_WE_EXT("Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed. Error message: %5$s", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR_WE.detailNumber);

    private final String message;
    private final int detailNumber;
    private final Category category;

    private MimeMailExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
    }

    private MimeMailExceptionCode(MailExceptionCode code, String message) {
        this.message = message;
        this.detailNumber = code.getNumber();
        this.category = code.getCategory();
    }

    private MimeMailExceptionCode(MailExceptionCode code) {
        this.message = code.getMessage();
        this.detailNumber = code.getNumber();
        this.category = code.getCategory();
    }

    public String getPrefix() {
        return "MSG";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return this.create(new Object[]{this, new Object[0]});
    }

    public OXException create(Object ... args) {
        return this.create(null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        MimeMailException ret;
        Category category = this.getCategory();
        if (category.getLogLevel().implies(LogLevel.DEBUG)) {
            ret = new MimeMailException(this.getNumber(), this.getMessage(), cause, args);
        } else if (OXExceptionFactory.DISPLAYABLE.contains(category.getType())) {
            ret = new MimeMailException(this.getNumber(), this.getMessage(), cause, args);
            ret.setLogMessage(this.getMessage(), args);
        } else {
            ret = new MimeMailException(this.getNumber(), Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "An error occurred. Please try again later." : "A severe error occurred.", cause, new Object[0]);
            ret.setLogMessage(this.getMessage(), args);
        }
        ret.addCategory(category);
        ret.setPrefix(this.getPrefix());
        return ret;
    }
}

