/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONException;
import org.json.JSONObject;

public final class ReceiptAckAction
extends AbstractMailAction {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ReceiptAckAction.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();

    public ReceiptAckAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            String uid;
            String folderPath;
            JSONObject bodyObj = (JSONObject)req.getRequest().getData();
            String string = folderPath = bodyObj.has("folder") ? bodyObj.getString("folder") : null;
            if (null == folderPath) {
                throw MailExceptionCode.MISSING_PARAM.create("folder");
            }
            String string2 = uid = bodyObj.has("id") ? bodyObj.getString("id") : null;
            if (null == uid) {
                throw MailExceptionCode.MISSING_PARAM.create("id");
            }
            String fromAddr = bodyObj.has(MailJSONField.FROM.getKey()) && !bodyObj.isNull(MailJSONField.FROM.getKey()) ? bodyObj.getString(MailJSONField.FROM.getKey()) : null;
            MailServletInterface mailInterface = this.getMailInterface(req);
            mailInterface.sendReceiptAck(folderPath, uid, fromAddr);
            return ReceiptAckAction.getJSONNullResult();
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

