/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="new", description="Send/Save mail as MIME data block (RFC822) (added in SP5)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", optional=true, description="In case the mail should not be sent out, but saved in a specific folder, the \"folder\" parameter can be used. If the mail should be sent out to the recipient, the \"folder\" parameter must not be included and the mail is stored in the folder \"Sent Items\". Example \"folder=default.INBOX/Testfolder\""), @Parameter(name="flags", optional=true, description="In case the mail should be stored with status \"read\" (e.g. mail has been read already in the client inbox), the parameter \"flags\" has to be included. If no \"folder\" parameter is specified, this parameter must not be included. For infos about mail flags see Detailed mail data spec.")}, requestBody="The MIME Data Block.", responseDescription="Object ID of the newly created/moved mail.")
public final class NewAction
extends AbstractMailAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(NewAction.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();

    public NewAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        AJAXRequestData request = req.getRequest();
        ArrayList<OXException> warnings = new ArrayList<OXException>();
        try {
            if (request.hasUploads() || request.getParameter("json_0") != null) {
                return this.performWithUploads(req, request, warnings);
            }
            return this.performWithoutUploads(req, warnings);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult performWithUploads(MailRequest req, AJAXRequestData request, List<OXException> warnings) throws OXException, JSONException {
        int accountId;
        InternetAddress from;
        ServerSession session = req.getSession();
        UploadEvent uploadEvent = request.getUploadEvent();
        String msgIdentifier = null;
        String json0 = uploadEvent.getFormField("json_0");
        if (json0 == null || json0.trim().length() == 0) {
            throw MailExceptionCode.PROCESSING_ERROR.create(MailExceptionCode.MISSING_PARAM.create("json_0"), new Object[0]);
        }
        JSONObject jsonMailObj = new JSONObject(json0);
        try {
            int endPos;
            String value = jsonMailObj.getString(MailJSONField.FROM.getKey());
            if (value.length() > 0 && '[' == value.charAt(0) && (endPos = value.indexOf(93, 1)) < value.length()) {
                value = new StringAllocator(32).append("\"[").append(value.substring(1, endPos)).append("]\"").append(value.substring(endPos + 1)).toString();
            }
            from = MimeMessageUtility.parseAddressList(value, true, true)[0];
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        try {
            accountId = NewAction.resolveFrom2Account(session, from, true, true);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e) || MailExceptionCode.INVALID_SENDER.equals(e)) {
                throw e;
            }
            LOG.warn((Object)new StringAllocator(128).append(e.getMessage()).append(". Using default account's transport.").toString());
            accountId = 0;
        }
        MailServletInterface mailInterface = this.getMailInterface(req);
        if (jsonMailObj.hasAndNotNull(MailJSONField.FLAGS.getKey()) && (jsonMailObj.getInt(MailJSONField.FLAGS.getKey()) & 4) > 0) {
            ComposedMailMessage composedMail = MessageParser.parse4Draft(jsonMailObj, uploadEvent, session, accountId, warnings);
            msgIdentifier = mailInterface.saveDraft(composedMail, false, accountId);
            if (msgIdentifier == null) {
                throw MailExceptionCode.DRAFT_FAILED_UNKNOWN.create();
            }
        } else {
            ComposedMailMessage[] composedMails = MessageParser.parse4Transport(jsonMailObj, uploadEvent, session, accountId, request.isSecure() ? "https://" : "http://", request.getHostname(), warnings);
            ComposeType sendType = jsonMailObj.hasAndNotNull("sendtype") ? ComposeType.getType(jsonMailObj.getInt("sendtype")) : ComposeType.NEW;
            for (ComposedMailMessage cm : composedMails) {
                if (null == cm) continue;
                cm.setSendType(sendType);
            }
            msgIdentifier = mailInterface.sendMessage(composedMails[0], sendType, accountId);
            for (int i = 1; i < composedMails.length; ++i) {
                mailInterface.sendMessage(composedMails[i], sendType, accountId);
            }
            try {
                ServerUserSetting setting = ServerUserSetting.getInstance();
                int contextId = session.getContextId();
                int userId = session.getUserId();
                if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailTransport(contextId, userId).booleanValue()) {
                    NewAction.triggerContactCollector(session, composedMails[0]);
                }
            }
            catch (OXException e) {
                LOG.warn((Object)"Contact collector could not be triggered.", (Throwable)e);
            }
        }
        if (msgIdentifier == null) {
            throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
        }
        AJAXRequestResult result = new AJAXRequestResult((Object)msgIdentifier, "string");
        result.addWarnings(warnings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult performWithoutUploads(MailRequest req, List<OXException> warnings) throws OXException, AddressException, MessagingException, JSONException {
        JSONObject responseData;
        MailMessage mail;
        QuotedInternetAddress fromAddress;
        ServerSession session = req.getSession();
        String folder = req.getParameter("folder");
        int i = req.optInt("flags");
        int flags = -9999 == i ? 0 : i;
        String tmp = req.getParameter("force");
        boolean force = null == tmp ? false : "1".equals(tmp = tmp.trim()) || Boolean.parseBoolean(tmp);
        QuotedInternetAddress defaultSendAddr = new QuotedInternetAddress(NewAction.getDefaultSendAddress(session), true);
        MimeMessage message = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new UnsynchronizedByteArrayInputStream(Charsets.toAsciiBytes((String)((String)req.getRequest().getData()))));
        message.removeHeader("x-original-headers");
        String fromAddr = message.getHeader("From", null);
        if (NewAction.isEmpty(fromAddr)) {
            fromAddress = defaultSendAddr;
            message.setFrom((Address)fromAddress);
            mail = MimeMessageConverter.convertMessage(message);
        } else {
            fromAddress = new QuotedInternetAddress(fromAddr, true);
            mail = MimeMessageConverter.convertMessage(message);
        }
        PutNewMailData data = new PutNewMailData(){

            @Override
            public MailMessage getMail() {
                return mail;
            }

            @Override
            public InternetAddress getFromAddress() {
                return fromAddress;
            }
        };
        if (folder == null) {
            responseData = this.appendDraft(session, flags, force, data.getFromAddress(), data.getMail());
        } else {
            String[] ids;
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            try {
                ids = mailInterface.appendMessages(folder, new MailMessage[]{data.getMail()}, force);
                if (flags > 0) {
                    mailInterface.updateMessageFlags(folder, ids, flags, true);
                }
            }
            finally {
                mailInterface.close(true);
            }
            JSONObject responseObj = new JSONObject();
            responseObj.put("folder_id", (Object)folder);
            responseObj.put("id", (Object)ids[0]);
            responseData = responseObj;
        }
        AJAXRequestResult result = new AJAXRequestResult((Object)responseData, "json");
        result.addWarnings(warnings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject appendDraft(ServerSession session, int flags, boolean force, InternetAddress from, MailMessage m) throws OXException, OXException, JSONException {
        int accId;
        try {
            accId = NewAction.resolveFrom2Account(session, from, true, !force);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                throw e;
            }
            if (!force && MailExceptionCode.INVALID_SENDER.equals(e)) {
                throw e;
            }
            LOG.warn((Object)new StringAllocator(128).append(e.getMessage()).append(". Using default account's transport.").toString());
            accId = 0;
        }
        int accountId = accId;
        MailTransport transport = MailTransport.getInstance(session, accountId);
        try {
            MailMessage sentMail = transport.sendRawMessage(m.getSourceBytes());
            JSONObject responseData = null;
            if (!session.getUserSettingMail().isNoCopyIntoStandardSentFolder()) {
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                try {
                    String[] uidArr;
                    mailAccess = MailAccess.getInstance(session, accountId);
                    mailAccess.connect();
                    String sentFullname = MailFolderUtility.prepareMailFolderParam(mailAccess.getFolderStorage().getSentFolder()).getFullname();
                    try {
                        if (flags != -9999) {
                            sentMail.setFlags(flags);
                        }
                        uidArr = mailAccess.getMessageStorage().appendMessages(sentFullname, new MailMessage[]{sentMail});
                        try {
                            MailMessageCache.getInstance().removeFolderMessages(accountId, sentFullname, session.getUserId(), session.getContext().getContextId());
                        }
                        catch (OXException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (OXException e) {
                        if (e.getMessage().indexOf("quota") != -1) {
                            throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.create(e, new Object[0]);
                    }
                    if (uidArr != null && uidArr[0] != null) {
                        mailAccess.getMessageStorage().updateMessageFlags(sentFullname, uidArr, 32, true);
                    }
                    responseData = new JSONObject();
                    responseData.put("folder_id", (Object)MailFolderUtility.prepareFullname(0, sentFullname));
                    responseData.put("id", (Object)uidArr[0]);
                }
                finally {
                    if (null != mailAccess) {
                        mailAccess.close(true);
                    }
                }
            }
            JSONObject jSONObject = responseData;
            return jSONObject;
        }
        finally {
            transport.close();
        }
    }

    private static interface PutNewMailData {
        public InternetAddress getFromAddress();

        public MailMessage getMail();
    }
}

