/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.event.impl.osgi.EventHandlerRegistration;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.session.Session;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class MailAccessCacheEventListener
implements EventHandlerRegistration {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAccessCacheEventListener.class));
    private ServiceRegistration serviceRegistration;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(Event event) {
        IMailAccessCache mac;
        String topic = event.getTopic();
        if ("com/openexchange/sessiond/remove/data".equals(topic) || "com/openexchange/sessiond/remove/container".equals(topic)) {
            IMailAccessCache mac2;
            Map sessions = (Map)event.getProperty("com.openexchange.sessiond.container");
            try {
                mac2 = MailAccess.getMailAccessCache();
            }
            catch (OXException e) {
                LOG.error((Object)"Managed mail access cache could not be obtained.", (Throwable)e);
                return;
            }
            for (Session session : sessions.values()) {
                try {
                    mac2.clearUserEntries(session);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)new StringAllocator(128).append("Detected a removed session: ").append(session.getSessionID()).append(". Removed all possibly cached mail access instances for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).toString());
                }
                catch (OXException e) {
                    LOG.error((Object)("Unable to clear cached mail access for session: " + session.getSessionID()), (Throwable)e);
                }
            }
            return;
        }
        if (!"com/openexchange/sessiond/remove/session".equals(topic)) return;
        Session session = (Session)event.getProperty("com.openexchange.sessiond.session");
        try {
            mac = MailAccess.getMailAccessCache();
        }
        catch (OXException e) {
            LOG.error((Object)"Managed mail access cache could not be obtained.", (Throwable)e);
            return;
        }
        try {
            mac.clearUserEntries(session);
            if (!LOG.isInfoEnabled()) return;
            LOG.info((Object)new StringAllocator(128).append("Detected a removed session: ").append(session.getSessionID()).append(". Removed all possibly cached mail access instances for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).toString());
            return;
        }
        catch (OXException e) {
            LOG.error((Object)("Unable to clear cached mail access for session: " + session.getSessionID()), (Throwable)e);
        }
    }

    @Override
    public void registerService(BundleContext context) {
        Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
        ((Dictionary)serviceProperties).put("event.topics", new String[]{"com/openexchange/sessiond/remove/data", "com/openexchange/sessiond/remove/container", "com/openexchange/sessiond/remove/session"});
        this.serviceRegistration = context.registerService(EventHandler.class.getName(), (Object)this, serviceProperties);
    }

    @Override
    public void unregisterService() {
        if (null != this.serviceRegistration) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

