/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.OXException;
import com.openexchange.image.ImageActionFactory;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;

@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public class ImageGetAction
implements AJAXActionService {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(ImageGetAction.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    public ImageGetAction(ServiceLookup services) {
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        String registrationName = null;
        String serlvetRequestURI = requestData.getSerlvetRequestURI();
        if (null == serlvetRequestURI) {
            if (DEBUG) {
                LOG.debug((Object)"Missing path information in image URL.");
            }
            throw AjaxExceptionCodes.BAD_REQUEST.create("Unknown image location.");
        }
        for (Map.Entry entry : ImageActionFactory.alias2regName.entrySet()) {
            String alias = (String)entry.getKey();
            if (!serlvetRequestURI.contains(alias)) continue;
            registrationName = (String)entry.getValue();
            break;
        }
        if (registrationName == null) {
            if (DEBUG) {
                LOG.debug((Object)("Request URI cannot be resolved to an image location: " + serlvetRequestURI));
            }
            throw AjaxExceptionCodes.BAD_REQUEST.create("Unknown image location.");
        }
        ImageDataSource dataSource = null;
        try {
            ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class, true);
            dataSource = (ImageDataSource)conversionService.getDataSource(registrationName);
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Missing ConversionService reference.", (Throwable)e);
            }
            throw AjaxExceptionCodes.BAD_REQUEST.create();
        }
        if (dataSource == null) {
            if (DEBUG) {
                LOG.debug((Object)("Data source cannot be found for: " + registrationName));
            }
            throw AjaxExceptionCodes.BAD_REQUEST.create("Invalid image location.");
        }
        ImageLocation imageLocation = dataSource.parseRequest(requestData);
        AJAXRequestResult requestResult = new AJAXRequestResult();
        try {
            String eTag = requestData.getHeader("If-None-Match");
            if (null != eTag && dataSource.getETag(imageLocation, session).equals(eTag)) {
                requestResult.setType(AJAXRequestResult.ResultType.ETAG);
                if (requestData.getExpires() > 0L) {
                    requestResult.setExpires(requestData.getExpires());
                }
                return requestResult;
            }
            requestResult = new AJAXRequestResult();
            ImageGetAction.outputImageData(dataSource, imageLocation, session, requestResult);
        }
        catch (OXException e) {
            if (DEBUG) {
                LOG.debug((Object)"Writing image data failed.", (Throwable)e);
            }
            throw AjaxExceptionCodes.BAD_REQUEST.create(e, new Object[0]);
        }
        return requestResult;
    }

    private static void outputImageData(ImageDataSource dataSource, ImageLocation imageLocation, Session session, AJAXRequestResult requestResult) throws OXException {
        Data data = dataSource.getData(InputStream.class, dataSource.generateDataArgumentsFrom(imageLocation), session);
        DataProperties dataProperties = data.getDataProperties();
        String ct = dataProperties.get("com.openexchange.conversion.content-type");
        String fileName = dataProperties.get("com.openexchange.conversion.name");
        InputStream in = (InputStream)data.getData();
        FileHolder fileHolder = new FileHolder(in, -1L, ct, fileName);
        fileHolder.setDelivery("view");
        requestResult.setResultObject(fileHolder, "file");
    }
}

