/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.impl;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public final class UploadUtility {
    private static final TIntObjectMap<String> M = new TIntObjectHashMap(13);

    private UploadUtility() {
    }

    public static String getSize(long size, int precision, boolean longName, boolean realSize) {
        int base;
        int pos = 0;
        double decSize = size;
        int n = base = realSize ? 1024 : 1000;
        while (decSize > (double)base) {
            decSize /= (double)base;
            ++pos;
        }
        int num = (int)Math.pow(10.0, precision);
        StringBuilder sb = new StringBuilder(8).append((double)Math.round(decSize * (double)num) / (double)num).append(' ');
        if (longName) {
            sb.append(UploadUtility.getSizePrefix(pos)).append("bytes");
        } else {
            String prefix = UploadUtility.getSizePrefix(pos);
            if (0 == prefix.length()) {
                sb.append("bytes");
            } else {
                sb.append(String.valueOf(prefix.charAt(0))).append('B');
            }
        }
        return sb.toString();
    }

    private static String getSizePrefix(int pos) {
        String prefix = (String)M.get(pos);
        if (prefix != null) {
            return prefix;
        }
        return "?-";
    }

    static {
        int pos = 0;
        M.put(pos++, (Object)"");
        M.put(pos++, (Object)"Kilo");
        M.put(pos++, (Object)"Mega");
        M.put(pos++, (Object)"Giga");
        M.put(pos++, (Object)"Tera");
        M.put(pos++, (Object)"Peta");
        M.put(pos++, (Object)"Exa");
        M.put(pos++, (Object)"Zetta");
        M.put(pos++, (Object)"Yotta");
        M.put(pos++, (Object)"Xenna");
        M.put(pos++, (Object)"W-");
        M.put(pos++, (Object)"Vendeka");
        M.put(pos++, (Object)"U-");
    }
}

