/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class CalendarAddIndex2DatesMembers
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.createMyIndex(con, new String[]{"prg_dates_members", "del_dates_members"}, "pfid", "givenname");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw CalendarAddIndex2DatesMembers.createSQLError(e);
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void createMyIndex(Connection con, String[] tables, String fieldName, String name) {
        org.apache.commons.logging.Log log = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarAddIndex2DatesMembers.class));
        String[] columns = new String[]{"cid", fieldName};
        StringBuilder sb = new StringBuilder(64);
        for (String table : tables) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    if (log.isInfoEnabled()) {
                        sb.setLength(0);
                        sb.append("Creating new index named \"");
                        sb.append(name);
                        sb.append("\" with columns (cid,");
                        sb.append(fieldName);
                        sb.append(") on table ");
                        sb.append(table);
                        sb.append('.');
                        log.info((Object)sb.toString());
                    }
                    Tools.createIndex(con, table, name, columns, false);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                sb.setLength(0);
                sb.append("New index named \"");
                sb.append(indexName);
                sb.append("\" with columns (cid,");
                sb.append(fieldName);
                sb.append(") already exists on table ");
                sb.append(table);
                sb.append('.');
                log.info((Object)sb.toString());
            }
            catch (SQLException e) {
                log.error((Object)("Problem adding index " + name + " on table " + table + '.'), (Throwable)e);
            }
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

