/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class AppointmentRepairRecurrenceString
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AppointmentRepairRecurrenceString.class));

    @Override
    public int addedWithVersion() {
        return 24;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException, OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Performing update task to repair the recurrence string in appointment change exceptions.");
        }
        String findBroken = "SELECT cid,intfield01,intfield02 FROM prg_dates WHERE intfield01!=intfield02 AND field06 IS NULL";
        Connection con = Database.get(contextId, true);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            con.setAutoCommit(false);
            stmt = con.prepareStatement("SELECT cid,intfield01,intfield02 FROM prg_dates WHERE intfield01!=intfield02 AND field06 IS NULL");
            result = stmt.executeQuery();
            while (result.next()) {
                int recurrenceId;
                String recurrenceString;
                int pos = 1;
                int cid = result.getInt(pos++);
                int id = result.getInt(pos++);
                if (null == (recurrenceString = this.getRecurrenceString(con, cid, recurrenceId = result.getInt(pos++)))) {
                    LOG.info((Object)("Series is missing for appointment " + id + " in context " + cid + "."));
                    continue;
                }
                LOG.info((Object)("Repairing appointment " + id + " in context " + cid + "."));
                this.fixRecurrenceString(con, cid, id, recurrenceString);
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.autocommit(con);
                DBUtils.closeSQLStuff(result, stmt);
                if (con != null) {
                    Database.back(contextId, true, con);
                }
                throw throwable;
            }
        }
        DBUtils.autocommit(con);
        DBUtils.closeSQLStuff(result, stmt);
        if (con != null) {
            Database.back(contextId, true, con);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Update task to repair the recurrence string in appointments performed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRecurrenceString(Connection con, int cid, int id) {
        String sql = "SELECT field06 FROM prg_dates WHERE cid=? AND intfield01=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        String retval = null;
        try {
            stmt = con.prepareStatement("SELECT field06 FROM prg_dates WHERE cid=? AND intfield01=?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            result = stmt.executeQuery();
            if (result.next()) {
                retval = result.getString(1);
            }
            DBUtils.closeSQLStuff(result, stmt);
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(result, stmt);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixRecurrenceString(Connection con, int cid, int id, String recurrenceString) {
        String sql = "UPDATE prg_dates SET field06=? WHERE cid=? AND intfield01=?";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE prg_dates SET field06=? WHERE cid=? AND intfield01=?");
            int pos = 1;
            stmt.setString(pos++, recurrenceString);
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, id);
            int updated = stmt.executeUpdate();
            if (1 != updated) {
                LOG.error((Object)("Strangely updated " + updated + " appointments instead of 1."));
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }
}

