/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.DependencyChecker;

public class DependenciesResolvedChecker
implements DependencyChecker {
    @Override
    public boolean check(UpdateTask task, String[] executed, UpdateTask[] enqueued, UpdateTask[] toExecute) {
        if (-1 != task.addedWithVersion()) {
            return false;
        }
        if (!(task instanceof UpdateTaskV2)) {
            return false;
        }
        for (UpdateTask other : toExecute) {
            if (-1 == other.addedWithVersion()) continue;
            return false;
        }
        for (String dependency : ((UpdateTaskV2)task).getDependencies()) {
            if (this.dependencyFulfilled(dependency, executed, enqueued)) continue;
            return false;
        }
        return true;
    }

    private boolean dependencyFulfilled(String dependency, String[] executed, UpdateTask[] enqueued) {
        for (String taskName : executed) {
            if (!taskName.equals(dependency)) continue;
            return true;
        }
        for (UpdateTask task : enqueued) {
            if (!task.getClass().getName().equals(dependency)) continue;
            return true;
        }
        return false;
    }
}

