/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tools.iterator;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class PrefetchIterator<T>
implements SearchIterator<T> {
    private final SearchIterator<T> impl;

    public PrefetchIterator(SearchIterator<T> delegate) throws OXException {
        boolean prefetch = ServerConfig.getBoolean(ServerConfig.Property.PrefetchEnabled);
        this.impl = prefetch ? new Prefetch<T>(delegate) : new NoPrefetch<T>(delegate);
    }

    public void close() throws OXException {
        this.impl.close();
    }

    public boolean hasNext() throws OXException {
        return this.impl.hasNext();
    }

    public T next() throws OXException {
        return (T)this.impl.next();
    }

    public int size() {
        return this.impl.size();
    }

    public void addWarning(OXException warning) {
        this.impl.addWarning(warning);
    }

    public OXException[] getWarnings() {
        return this.impl.getWarnings();
    }

    public boolean hasWarnings() {
        return this.impl.hasWarnings();
    }

    private static final class NoPrefetch<T>
    implements SearchIterator<T> {
        private final SearchIterator<T> delegate;

        NoPrefetch(SearchIterator<T> delegate) {
            this.delegate = delegate;
        }

        public void close() throws OXException {
            this.delegate.close();
        }

        public boolean hasNext() throws OXException {
            return this.delegate.hasNext();
        }

        public T next() throws OXException {
            return (T)this.delegate.next();
        }

        public int size() {
            return this.delegate.size();
        }

        public void addWarning(OXException warning) {
            this.delegate.addWarning(warning);
        }

        public OXException[] getWarnings() {
            return this.delegate.getWarnings();
        }

        public boolean hasWarnings() {
            return this.delegate.hasWarnings();
        }
    }

    private static final class Prefetch<T>
    implements SearchIterator<T> {
        private final SearchIterator<T> delegate;
        private Queue<T> data;
        private final List<OXException> warnings = new ArrayList<OXException>(2);
        private OXException oxExc;
        private SearchIteratorException closeexc;

        Prefetch(SearchIterator<T> delegate) throws OXException {
            this.delegate = delegate;
            this.fetch();
            if (delegate.hasWarnings()) {
                this.warnings.addAll(Arrays.asList(delegate.getWarnings()));
            }
        }

        private void fetch() throws OXException {
            this.data = new LinkedList<T>();
            while (this.delegate.hasNext()) {
                try {
                    this.data.add(this.delegate.next());
                }
                catch (OXException e) {
                    this.oxExc = e;
                    break;
                }
            }
            try {
                this.delegate.close();
            }
            catch (SearchIteratorException e) {
                this.closeexc = e;
            }
        }

        public void close() throws SearchIteratorException, OXException {
            this.data.clear();
            if (null != this.closeexc) {
                throw this.closeexc;
            }
        }

        public boolean hasNext() throws OXException {
            return !this.data.isEmpty() || null != this.oxExc;
        }

        public boolean hasSize() {
            return true;
        }

        public T next() throws OXException {
            if (this.data.isEmpty()) {
                if (null != this.oxExc) {
                    throw this.oxExc;
                }
                throw SearchIteratorExceptionCodes.NO_SUCH_ELEMENT.create().setPrefix(EnumComponent.APPOINTMENT.getAbbreviation());
            }
            return this.data.poll();
        }

        public int size() {
            return this.data.size();
        }

        public void addWarning(OXException warning) {
            this.warnings.add(warning);
        }

        public OXException[] getWarnings() {
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }
}

