/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.tools.encoding.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class UserTools {
    private static final String UTF_8 = "UTF-8";
    private static final String HASH_ALGO = "SHA-1";

    private UserTools() {
    }

    static String hashPassword(String password) throws OXException {
        String hashed = null;
        try {
            MessageDigest sha = MessageDigest.getInstance(HASH_ALGO);
            sha.update(password.getBytes(UTF_8));
            byte[] hash = sha.digest();
            hashed = Base64.encode(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw UserExceptionCode.HASHING.create(e, HASH_ALGO);
        }
        catch (UnsupportedEncodingException e) {
            throw UserExceptionCode.UNSUPPORTED_ENCODING.create(e, UTF_8);
        }
        return hashed;
    }
}

