/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.utils;

import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.infostore.utils.MetadataSwitcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Metadata {
    public static final int LAST_MODIFIED = 5;
    public static final int CREATION_DATE = 4;
    public static final int MODIFIED_BY = 3;
    public static final int FOLDER_ID = 20;
    public static final int TITLE = 700;
    public static final int VERSION = 705;
    public static final int CONTENT = 750;
    public static final int FILESTORE_LOCATION = 752;
    public static final int FILENAME = 702;
    public static final int SEQUENCE_NUMBER = 751;
    public static final int ID = 1;
    public static final int FILE_SIZE = 704;
    public static final int FILE_MIMETYPE = 703;
    public static final int DESCRIPTION = 706;
    public static final int LOCKED_UNTIL = 707;
    public static final int URL = 701;
    public static final int CREATED_BY = 2;
    public static final int CATEGORIES = 100;
    public static final int FILE_MD5SUM = 708;
    public static final int VERSION_COMMENT = 709;
    public static final int CURRENT_VERSION = 710;
    public static final int NUMBER_OF_VERSIONS = 711;
    public static final int COLOR_LABEL = 102;
    public static final int LAST_MODIFIED_UTC = 6;
    public static final Metadata LAST_MODIFIED_LITERAL = new Metadata(5, "last_modified");
    public static final Metadata CREATION_DATE_LITERAL = new Metadata(4, "creation_date");
    public static final Metadata MODIFIED_BY_LITERAL = new Metadata(3, "modified_by");
    public static final Metadata FOLDER_ID_LITERAL = new Metadata(20, "folder_id");
    public static final Metadata TITLE_LITERAL = new Metadata(700, "title");
    public static final Metadata VERSION_LITERAL = new Metadata(705, "version");
    public static final Metadata CONTENT_LITERAL = new Metadata(750, "content");
    public static final Metadata ID_LITERAL = new Metadata(1, "id");
    public static final Metadata FILE_SIZE_LITERAL = new Metadata(704, "file_size");
    public static final Metadata DESCRIPTION_LITERAL = new Metadata(706, "description");
    public static final Metadata URL_LITERAL = new Metadata(701, "url");
    public static final Metadata CREATED_BY_LITERAL = new Metadata(2, "created_by");
    public static final Metadata FILENAME_LITERAL = new Metadata(702, "filename");
    public static final Metadata FILE_MIMETYPE_LITERAL = new Metadata(703, "file_mimetype");
    public static final Metadata SEQUENCE_NUMBER_LITERAL = new Metadata(751, "sequence_number");
    public static final Metadata CATEGORIES_LITERAL = new Metadata(100, "categories");
    public static final Metadata LOCKED_UNTIL_LITERAL = new Metadata(707, "locked_until");
    public static final Metadata FILE_MD5SUM_LITERAL = new Metadata(708, "file_md5sum");
    public static final Metadata VERSION_COMMENT_LITERAL = new Metadata(709, "version_comment");
    public static final Metadata CURRENT_VERSION_LITERAL = new Metadata(710, "current_version");
    public static final Metadata COLOR_LABEL_LITERAL = new Metadata(102, "color_label");
    public static final Metadata FILESTORE_LOCATION_LITERAL = new Metadata(752, "filestore_location");
    public static final Metadata LAST_MODIFIED_UTC_LITERAL = new Metadata(6, "last_modified_utc");
    public static final Metadata NUMBER_OF_VERSIONS_LITERAL = new Metadata(711, "number_of_versions");
    public static final Metadata[] VALUES_ARRAY = new Metadata[]{LAST_MODIFIED_LITERAL, CREATION_DATE_LITERAL, MODIFIED_BY_LITERAL, FOLDER_ID_LITERAL, TITLE_LITERAL, VERSION_LITERAL, CONTENT_LITERAL, ID_LITERAL, FILE_SIZE_LITERAL, DESCRIPTION_LITERAL, URL_LITERAL, CREATED_BY_LITERAL, FILENAME_LITERAL, FILE_MIMETYPE_LITERAL, SEQUENCE_NUMBER_LITERAL, CATEGORIES_LITERAL, LOCKED_UNTIL_LITERAL, FILE_MD5SUM_LITERAL, VERSION_COMMENT_LITERAL, CURRENT_VERSION_LITERAL, COLOR_LABEL_LITERAL, FILESTORE_LOCATION_LITERAL, LAST_MODIFIED_UTC_LITERAL, NUMBER_OF_VERSIONS_LITERAL};
    public static final Metadata[] HTTPAPI_VALUES_ARRAY = new Metadata[]{LAST_MODIFIED_LITERAL, CREATION_DATE_LITERAL, MODIFIED_BY_LITERAL, FOLDER_ID_LITERAL, TITLE_LITERAL, VERSION_LITERAL, CONTENT_LITERAL, ID_LITERAL, FILE_SIZE_LITERAL, DESCRIPTION_LITERAL, URL_LITERAL, CREATED_BY_LITERAL, FILENAME_LITERAL, FILE_MIMETYPE_LITERAL, CATEGORIES_LITERAL, LOCKED_UNTIL_LITERAL, FILE_MD5SUM_LITERAL, VERSION_COMMENT_LITERAL, CURRENT_VERSION_LITERAL, COLOR_LABEL_LITERAL, LAST_MODIFIED_UTC_LITERAL, NUMBER_OF_VERSIONS_LITERAL};
    public static final List<Metadata> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    public static final List<Metadata> HTTPAPI_VALUES = Collections.unmodifiableList(Arrays.asList(HTTPAPI_VALUES_ARRAY));
    private final String name;
    private final int id;

    private Metadata(int id, String name) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static Metadata get(int id) {
        switch (id) {
            case 5: {
                return LAST_MODIFIED_LITERAL;
            }
            case 4: {
                return CREATION_DATE_LITERAL;
            }
            case 3: {
                return MODIFIED_BY_LITERAL;
            }
            case 20: {
                return FOLDER_ID_LITERAL;
            }
            case 700: {
                return TITLE_LITERAL;
            }
            case 705: {
                return VERSION_LITERAL;
            }
            case 750: {
                return CONTENT_LITERAL;
            }
            case 1: {
                return ID_LITERAL;
            }
            case 704: {
                return FILE_SIZE_LITERAL;
            }
            case 706: {
                return DESCRIPTION_LITERAL;
            }
            case 701: {
                return URL_LITERAL;
            }
            case 2: {
                return CREATED_BY_LITERAL;
            }
            case 702: {
                return FILENAME_LITERAL;
            }
            case 703: {
                return FILE_MIMETYPE_LITERAL;
            }
            case 751: {
                return SEQUENCE_NUMBER_LITERAL;
            }
            case 100: {
                return CATEGORIES_LITERAL;
            }
            case 707: {
                return LOCKED_UNTIL_LITERAL;
            }
            case 708: {
                return FILE_MD5SUM_LITERAL;
            }
            case 709: {
                return VERSION_COMMENT_LITERAL;
            }
            case 710: {
                return CURRENT_VERSION_LITERAL;
            }
            case 102: {
                return COLOR_LABEL_LITERAL;
            }
            case 752: {
                return FILESTORE_LOCATION_LITERAL;
            }
            case 6: {
                return LAST_MODIFIED_UTC_LITERAL;
            }
            case 711: {
                return NUMBER_OF_VERSIONS_LITERAL;
            }
        }
        return null;
    }

    public static Metadata get(String s) {
        for (Metadata metadata : VALUES) {
            if (!metadata.getName().equals(s)) continue;
            return metadata;
        }
        return null;
    }

    public Object doSwitch(MetadataSwitcher switcher) {
        switch (this.id) {
            case 5: {
                return switcher.lastModified();
            }
            case 4: {
                return switcher.creationDate();
            }
            case 3: {
                return switcher.modifiedBy();
            }
            case 20: {
                return switcher.folderId();
            }
            case 700: {
                return switcher.title();
            }
            case 705: {
                return switcher.version();
            }
            case 750: {
                return switcher.content();
            }
            case 1: {
                return switcher.id();
            }
            case 704: {
                return switcher.fileSize();
            }
            case 706: {
                return switcher.description();
            }
            case 701: {
                return switcher.url();
            }
            case 2: {
                return switcher.createdBy();
            }
            case 702: {
                return switcher.fileName();
            }
            case 703: {
                return switcher.fileMIMEType();
            }
            case 751: {
                return switcher.sequenceNumber();
            }
            case 100: {
                return switcher.categories();
            }
            case 707: {
                return switcher.lockedUntil();
            }
            case 708: {
                return switcher.fileMD5Sum();
            }
            case 709: {
                return switcher.versionComment();
            }
            case 710: {
                return switcher.currentVersion();
            }
            case 102: {
                return switcher.colorLabel();
            }
            case 752: {
                return switcher.filestoreLocation();
            }
            case 6: {
                return switcher.lastModifiedUTC();
            }
            case 711: {
                return switcher.numberOfVersions();
            }
        }
        return null;
    }

    public static AttachmentField getAttachmentField(Metadata attachmentCompatible) {
        switch (attachmentCompatible.getId()) {
            case 702: {
                return AttachmentField.FILENAME_LITERAL;
            }
            case 704: {
                return AttachmentField.FILE_SIZE_LITERAL;
            }
            case 703: {
                return AttachmentField.FILE_MIMETYPE_LITERAL;
            }
            case 700: {
                return AttachmentField.FILENAME_LITERAL;
            }
            case 706: {
                return AttachmentField.COMMENT_LITERAL;
            }
        }
        return null;
    }
}

