/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search.impl;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.sql.SearchStrings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;

public class SearchEngineImpl
extends DBService
implements InfostoreSearchEngine {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SearchEngineImpl.class));
    private final InfostoreSecurityImpl security = new InfostoreSecurityImpl();
    private static final String[] SEARCH_FIELDS = new String[]{"infostore_document.title", "infostore_document.url", "infostore_document.description", "infostore_document.categories", "infostore_document.filename", "infostore_document.file_version_comment"};

    public SearchEngineImpl() {
        super(null);
    }

    public SearchEngineImpl(DBProvider provider) {
        super(provider);
        this.security.setProvider(provider);
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        if (this.security != null) {
            this.security.setProvider(provider);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SearchIterator<DocumentMetadata> search(String query, Metadata[] cols, int folderId, Metadata sortedBy, int dir, int start, int end, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkPatternLength(String pattern) throws OXException {
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters) {
            return;
        }
        if (null != pattern && SearchStrings.lengthWithoutWildcards(pattern) < minimumSearchCharacters) {
            throw InfostoreExceptionCodes.PATTERN_NEEDS_MORE_CHARACTERS.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    private String join(List<Integer> all) {
        StringBuffer joined = new StringBuffer();
        for (Integer i : all) {
            joined.append(i.toString());
            joined.append(',');
        }
        joined.setLength(joined.length() - 1);
        return joined.toString();
    }

    @Override
    public void index(DocumentMetadata document, Context ctx, User user, UserConfiguration userConfig) {
    }

    @Override
    public void unIndex0r(int id, Context ctx, User user, UserConfiguration userConfig) {
    }

    private String[] switchMetadata2DBColumns(Metadata[] columns) {
        ArrayList<String> retval = new ArrayList<String>();
        block23: for (Metadata current : columns) {
            switch (current.getId()) {
                default: {
                    continue block23;
                }
                case 5: {
                    retval.add("infostore.last_modified");
                    continue block23;
                }
                case 6: {
                    retval.add("infostore.last_modified");
                    continue block23;
                }
                case 4: {
                    retval.add("infostore.creating_date");
                    continue block23;
                }
                case 3: {
                    retval.add("infostore.changed_by");
                    continue block23;
                }
                case 20: {
                    retval.add("infostore.folder_id");
                    continue block23;
                }
                case 700: {
                    retval.add("infostore_document.title");
                    continue block23;
                }
                case 705: {
                    retval.add("infostore.version");
                    continue block23;
                }
                case 750: {
                    retval.add("infostore_document.description");
                    continue block23;
                }
                case 702: {
                    retval.add("infostore_document.filename");
                    continue block23;
                }
                case 751: {
                    retval.add("infostore.id");
                    continue block23;
                }
                case 1: {
                    retval.add("infostore.id");
                    continue block23;
                }
                case 704: {
                    retval.add("infostore_document.file_size");
                    continue block23;
                }
                case 703: {
                    retval.add("infostore_document.file_mimetype");
                    continue block23;
                }
                case 706: {
                    retval.add("infostore_document.description");
                    continue block23;
                }
                case 707: {
                    retval.add("infostore.locked_until");
                    continue block23;
                }
                case 701: {
                    retval.add("infostore_document.url");
                    continue block23;
                }
                case 2: {
                    retval.add("infostore.created_by");
                    continue block23;
                }
                case 100: {
                    retval.add("infostore_document.categories");
                    continue block23;
                }
                case 708: {
                    retval.add("infostore_document.file_md5sum");
                    continue block23;
                }
                case 709: {
                    retval.add("infostore_document.file_version_comment");
                    continue block23;
                }
                case 102: {
                    retval.add("infostore.color_label");
                }
            }
        }
        return retval.toArray(new String[0]);
    }

    private String getResultFieldsSelect(Metadata[] RESULT_FIELDS) {
        String[] DB_RESULT_FIELDS = this.switchMetadata2DBColumns(RESULT_FIELDS);
        StringBuilder selectFields = new StringBuilder();
        boolean id = false;
        for (String currentField : DB_RESULT_FIELDS) {
            if (currentField.equals("infostore.id")) {
                currentField = "infostore.id";
                id = true;
            }
            selectFields.append(currentField);
            selectFields.append(", ");
        }
        if (!id) {
            selectFields.append("infostore.id,");
        }
        String retval = "";
        if (selectFields.length() > 0) {
            retval = "SELECT DISTINCT " + selectFields.toString();
            retval = retval.substring(0, retval.lastIndexOf(", "));
        }
        return retval;
    }

    public static class InfostoreSearchIterator
    implements SearchIterator<DocumentMetadata> {
        private DocumentMetadata next;
        private ResultSet rs;
        private final Metadata[] columns;
        private final SearchEngineImpl s;
        private final Context ctx;
        private Connection readCon;
        private Statement stmt;
        private final List<OXException> warnings = new ArrayList<OXException>(2);

        public InfostoreSearchIterator(ResultSet rs, SearchEngineImpl s, Metadata[] columns, Context ctx, Connection readCon, Statement stmt) throws OXException {
            this.rs = rs;
            this.s = s;
            this.columns = columns;
            this.ctx = ctx;
            this.readCon = readCon;
            this.stmt = stmt;
            try {
                if (rs.next()) {
                    this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.INFOSTORE});
            }
        }

        public boolean hasNext() throws OXException {
            return this.next != null;
        }

        public DocumentMetadata next() throws OXException, OXException {
            try {
                DocumentMetadata retval = null;
                retval = this.next;
                if (this.rs.next()) {
                    this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    while (this.next == null && this.rs.next()) {
                        this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    }
                    if (this.next == null) {
                        this.close();
                    }
                } else {
                    this.close();
                }
                return retval;
            }
            catch (Exception exc) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)exc, new Object[]{EnumComponent.INFOSTORE});
            }
        }

        public void close() throws OXException {
            this.next = null;
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.rs = null;
            }
            catch (SQLException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.stmt = null;
            }
            catch (SQLException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
            if (null != this.readCon) {
                this.s.releaseReadConnection(this.ctx, this.readCon);
                this.readCon = null;
            }
        }

        public int size() {
            return -1;
        }

        public boolean hasSize() {
            return false;
        }

        public void addWarning(OXException warning) {
            this.warnings.add(warning);
        }

        public OXException[] getWarnings() {
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        private DocumentMetadataImpl fillDocumentMetadata(DocumentMetadataImpl retval, Metadata[] columns, ResultSet result) throws SQLException {
            block23: for (int i = 0; i < columns.length; ++i) {
                switch (columns[i].getId()) {
                    default: {
                        continue block23;
                    }
                    case 5: {
                        retval.setLastModified(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 6: {
                        retval.setLastModified(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 4: {
                        retval.setCreationDate(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 3: {
                        retval.setModifiedBy(result.getInt(i + 1));
                        continue block23;
                    }
                    case 20: {
                        retval.setFolderId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 700: {
                        retval.setTitle(result.getString(i + 1));
                        continue block23;
                    }
                    case 705: {
                        retval.setVersion(result.getInt(i + 1));
                        continue block23;
                    }
                    case 750: {
                        retval.setDescription(result.getString(i + 1));
                        continue block23;
                    }
                    case 702: {
                        retval.setFileName(result.getString(i + 1));
                        continue block23;
                    }
                    case 751: {
                        retval.setId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 1: {
                        retval.setId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 704: {
                        retval.setFileSize(result.getInt(i + 1));
                        continue block23;
                    }
                    case 703: {
                        retval.setFileMIMEType(result.getString(i + 1));
                        continue block23;
                    }
                    case 706: {
                        retval.setDescription(result.getString(i + 1));
                        continue block23;
                    }
                    case 707: {
                        retval.setLockedUntil(new Date(result.getLong(i + 1)));
                        if (!result.wasNull()) continue block23;
                        retval.setLockedUntil(null);
                        continue block23;
                    }
                    case 701: {
                        retval.setURL(result.getString(i + 1));
                        continue block23;
                    }
                    case 2: {
                        retval.setCreatedBy(result.getInt(i + 1));
                        continue block23;
                    }
                    case 100: {
                        retval.setCategories(result.getString(i + 1));
                        continue block23;
                    }
                    case 708: {
                        retval.setFileMD5Sum(result.getString(i + 1));
                        continue block23;
                    }
                    case 709: {
                        retval.setVersionComment(result.getString(i + 1));
                        continue block23;
                    }
                    case 102: {
                        retval.setColorLabel(result.getInt(i + 1));
                    }
                }
            }
            retval.setIsCurrentVersion(true);
            return retval;
        }
    }
}

