/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.exceptions.SimpleTruncatedAttribute;
import com.openexchange.tools.sql.DBUtils;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CheckSizeSwitch {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CheckSizeSwitch.class));
    private static Map<Metadata, Integer> SIZES = new HashMap<Metadata, Integer>();
    private final DBProvider provider;
    private final Context ctx;
    private static final Set<Metadata> FIELDS_TO_CHECK = new HashSet<Metadata>(){
        {
            this.add(Metadata.CATEGORIES_LITERAL);
            this.add(Metadata.FILE_MIMETYPE_LITERAL);
            this.add(Metadata.FILENAME_LITERAL);
            this.add(Metadata.URL_LITERAL);
            this.add(Metadata.DESCRIPTION_LITERAL);
            this.add(Metadata.TITLE_LITERAL);
            this.add(Metadata.VERSION_COMMENT_LITERAL);
        }
    };

    public CheckSizeSwitch(DBProvider provider, Context ctx) {
        this.provider = provider;
        this.ctx = ctx;
    }

    public static void checkSizes(DocumentMetadata metadata, DBProvider provider, Context ctx) throws OXException {
        boolean error = false;
        CheckSizeSwitch checkSize = new CheckSizeSwitch(provider, ctx);
        GetSwitch get = new GetSwitch(metadata);
        OXException x = InfostoreExceptionCodes.TOO_LONG_VALUES.create();
        for (Metadata m : Metadata.VALUES) {
            int valueLength;
            if (!FIELDS_TO_CHECK.contains(m)) continue;
            Object value = m.doSwitch(get);
            int maxSize = checkSize.getSize(m);
            if (maxSize >= (valueLength = value instanceof String ? Charsets.getBytes((String)((String)value), (Charset)Charsets.UTF_8).length : 0)) continue;
            SimpleTruncatedAttribute attr = new SimpleTruncatedAttribute(m.getId(), maxSize, valueLength);
            x.addProblematic((OXException.ProblematicAttribute)attr);
            error = true;
        }
        if (error) {
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(Metadata field) {
        if (SIZES.containsKey(field)) {
            return SIZES.get(field);
        }
        Connection con = null;
        try {
            con = this.provider.getWriteConnection(this.ctx);
            String[] tuple = new InfostoreQueryCatalog().getFieldTuple(field, new InfostoreQueryCatalog.VersionWins());
            int size = DBUtils.getColumnSize(con, tuple[0], tuple[1]);
            SIZES.put(field, size);
            int n = size;
            return n;
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.provider.releaseWriteConnection(this.ctx, con);
        }
    }
}

