/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.dynamic.OXObjectFactory;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.filestore.Filestore;
import com.openexchange.groupware.filestore.FilestoreReloader;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.sql.Connection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CachingFilestoreStorage
extends FilestoreStorage {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CachingFilestoreStorage.class));
    private static final String REGION_NAME = "Filestore";
    static final Lock CACHE_LOCK = new ReentrantLock();
    private final FilestoreStorage delegate;

    public CachingFilestoreStorage(FilestoreStorage fs) {
        this.delegate = fs;
    }

    @Override
    public Filestore getFilestore(int id) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        FilestoreFactory factory = new FilestoreFactory(id, this.delegate);
        if (cacheService == null) {
            return (Filestore)factory.load();
        }
        return new FilestoreReloader(factory, REGION_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filestore getFilestore(Connection con, int id) throws OXException {
        CacheService service = ServerServiceRegistry.getInstance().getService(CacheService.class);
        Cache filestoreCache = null;
        if (service != null) {
            try {
                filestoreCache = service.getCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Filestore retval = null;
        if (null != filestoreCache) {
            retval = (Filestore)filestoreCache.get((Serializable)Autoboxing.I((int)id));
        }
        if (null == retval) {
            retval = this.delegate.getFilestore(con, id);
            if (null != filestoreCache) {
                CACHE_LOCK.lock();
                try {
                    filestoreCache.put((Serializable)Autoboxing.I((int)id), (Serializable)retval, false);
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    CACHE_LOCK.unlock();
                }
            }
        }
        return retval;
    }

    private static final class FilestoreFactory
    implements OXObjectFactory<Filestore> {
        private static final long serialVersionUID = -4542868153240572103L;
        private final Integer id;
        private final FilestoreStorage delegate;

        protected FilestoreFactory(int id, FilestoreStorage delegate) {
            this.id = Autoboxing.I((int)id);
            this.delegate = delegate;
        }

        public Serializable getKey() {
            return this.id;
        }

        public Filestore load() throws OXException {
            return this.delegate.getFilestore(this.id);
        }

        public Lock getCacheLock() {
            return CACHE_LOCK;
        }
    }
}

