/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.config.ConfigurationService;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Map;
import java.util.Properties;

public class ContactConfig {
    private static final String FILENAME = "contact.properties";
    private static final ContactConfig SINGLETON = new ContactConfig();
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ContactConfig.class));
    private final Properties props = new Properties();
    private long maxImageSize = 33750000L;

    private ContactConfig() {
    }

    public static ContactConfig getInstance() {
        return SINGLETON;
    }

    public void initialize(ConfigurationService configuration) {
        Properties props = configuration.getFile(FILENAME);
        if (null == props) {
            LOG.info((Object)"Configuration file contact.properties is missing. Using defaults.");
        } else {
            this.props.clear();
            this.props.putAll((Map<?, ?>)props);
            LOG.info((Object)"Read configuration file contact.properties.");
        }
        this.parse();
    }

    private void parse() {
        try {
            this.maxImageSize = Long.parseLong(this.getString(Property.MAX_IMAGE_SIZE));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Unable to parse value of property " + Property.MAX_IMAGE_SIZE.propertyName + " in " + FILENAME + '.'), (Throwable)e);
            this.maxImageSize = 33750000L;
        }
    }

    public String getProperty(String key) {
        this.logNotInitialized();
        return this.props.getProperty(key);
    }

    public String getString(Property key) {
        this.logNotInitialized();
        return this.props.getProperty(key.propertyName, key.defaultValue);
    }

    public Boolean getBoolean(Property key) {
        this.logNotInitialized();
        return Boolean.valueOf(this.props.getProperty(key.propertyName, key.defaultValue));
    }

    private void logNotInitialized() {
        if (this.props.isEmpty()) {
            LOG.info((Object)"Configuration file contact.properties not read. Using defaults.");
        }
    }

    public long getMaxImageSize() {
        this.logNotInitialized();
        return this.maxImageSize;
    }

    public static enum Property {
        AUTO_SEARCH("com.openexchange.contact.mailAddressAutoSearch", Boolean.TRUE.toString()),
        SINGLE_FOLDER_SEARCH("com.openexchange.contact.singleFolderSearch", Boolean.TRUE.toString()),
        LETTER_FIELD("contact_first_letter_field", "field02"),
        CHARACTER_SEARCH("com.openexchange.contacts.characterSearch", Boolean.TRUE.toString()),
        ALL_FOLDERS_FOR_AUTOCOMPLETE("com.openexchange.contacts.allFoldersForAutoComplete", Boolean.TRUE.toString()),
        MAX_IMAGE_SIZE("max_image_size", "33750000");

        private String propertyName;
        private String defaultValue;

        private Property(String keyName, String value) {
            this.propertyName = keyName;
            this.defaultValue = value;
        }
    }
}

