/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class AlterCreatingDate
implements UpdateTask {
    private static final String UPDATE_PRG_DATES = "alter table prg_dates change column creating_date creating_date timestamp DEFAULT CURRENT_TIMESTAMP";

    @Override
    public int addedWithVersion() {
        return 6;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        block9: {
            Connection writecon = null;
            Statement stmt = null;
            try {
                writecon = Database.get(contextId, true);
                try {
                    stmt = writecon.createStatement();
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
                }
                if (stmt == null) break block9;
                try {
                    stmt.executeUpdate(UPDATE_PRG_DATES);
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex, new Object[0]);
                }
            }
            finally {
                if (stmt != null) {
                    ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class).closeStatement(stmt);
                }
                if (writecon != null) {
                    Database.back(contextId, true, writecon);
                }
            }
        }
    }
}

