/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.session.ServerSession;

public class CalendarAttachments
implements AttachmentListener,
AttachmentAuthorization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarAttachments.class));

    @Override
    public long attached(AttachmentEvent e) throws Exception {
        AppointmentSQLInterface csql = CalendarAttachments.getInterface(e.getSession());
        return csql.attachmentAction(e.getFolderId(), e.getAttachedId(), e.getUser().getId(), e.getSession(), e.getContext(), 1);
    }

    @Override
    public long detached(AttachmentEvent e) throws Exception {
        AppointmentSQLInterface csql = CalendarAttachments.getInterface(e.getSession());
        return csql.attachmentAction(e.getFolderId(), e.getAttachedId(), e.getUser().getId(), e.getSession(), e.getContext(), -e.getDetached().length);
    }

    private static AppointmentSQLInterface getInterface(Session session) {
        return ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
    }

    @Override
    public void checkMayAttach(ServerSession session, int folderId, int objectId) throws OXException {
        try {
            CalendarCollectionService collection = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            if (!collection.getWritePermission(objectId, folderId, session, session.getContext())) {
                throw OXCalendarExceptionCodes.NO_PERMISSIONS_TO_ATTACH_DETACH.create();
            }
        }
        catch (OXException e) {
            if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                LOG.error((Object)StringCollection.convertArraytoString(new Object[]{"checkMayAttach failed. The object does not exists (cid:oid) : ", session.getContextId(), ":", objectId}));
            }
            throw e;
        }
        catch (Exception e) {
            throw OXCalendarExceptionCodes.UNEXPECTED_EXCEPTION.create(e, 14);
        }
    }

    @Override
    public void checkMayDetach(ServerSession session, int folderId, int objectId) throws OXException {
        this.checkMayAttach(session, folderId, objectId);
    }

    @Override
    public void checkMayReadAttachments(ServerSession session, int folderId, int objectId) throws OXException {
        try {
            CalendarCollectionService collection = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
            if (!collection.getReadPermission(objectId, folderId, session, session.getContext())) {
                throw OXCalendarExceptionCodes.NO_PERMISSIONS_TO_READ.create();
            }
        }
        catch (OXException e) {
            if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                LOG.error((Object)StringCollection.convertArraytoString(new Object[]{"checkMayReadAttachments failed. The object does not exists (cid:oid) : ", session.getContextId(), ":", objectId}));
            }
            throw e;
        }
        catch (Exception e) {
            throw OXCalendarExceptionCodes.UNEXPECTED_EXCEPTION.create(e, 15);
        }
    }
}

