/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class LocalizedDatabaseFolder
extends DatabaseFolder {
    private static final long serialVersionUID = 3830248343115931304L;
    private ConcurrentMap<Locale, String> localizedNames = new NonBlockingHashMap(8);

    public LocalizedDatabaseFolder(FolderObject folderObject) {
        this(folderObject, true);
    }

    public LocalizedDatabaseFolder(FolderObject folderObject, boolean cacheable) {
        super(folderObject, cacheable);
    }

    @Override
    public Object clone() {
        LocalizedDatabaseFolder clone = (LocalizedDatabaseFolder)super.clone();
        ConcurrentMap<Locale, String> thisMap = this.localizedNames;
        if (null == this.localizedNames) {
            clone.localizedNames = null;
        } else {
            NonBlockingHashMap cloneMap = new NonBlockingHashMap(thisMap.size());
            for (Map.Entry entry : thisMap.entrySet()) {
                cloneMap.put(entry.getKey(), entry.getValue());
            }
            clone.localizedNames = cloneMap;
        }
        return clone;
    }

    @Override
    public String getLocalizedName(Locale locale) {
        Locale loc = null == locale ? LocaleTools.DEFAULT_LOCALE : locale;
        String translation = (String)this.localizedNames.get(loc);
        if (null == translation) {
            String fname = this.getName();
            if (null == fname) {
                return null;
            }
            String ntranslation = StringHelper.valueOf(loc).getString(fname);
            translation = this.localizedNames.putIfAbsent(loc, ntranslation);
            if (null == translation) {
                translation = ntranslation;
            }
        }
        return translation;
    }
}

